/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.keycloak;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.IllformedLocaleException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.fao.geonet.kernel.security.keycloak.KeycloakUserUtils;
import org.fao.geonet.kernel.security.keycloak.KeycloakUtil;
import org.fao.geonet.utils.Log;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.springsecurity.filter.QueryParamPresenceRequestMatcher;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class KeycloakAuthenticationProcessingFilter
extends org.keycloak.adapters.springsecurity.filter.KeycloakAuthenticationProcessingFilter {
    private RequestCache requestCache;
    @Autowired
    private KeycloakUserUtils keycloakUserUtils;
    public static final RequestMatcher DEFAULT_REQUEST_MATCHER = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher(KeycloakUtil.getSigninPath()), new RequestHeaderRequestMatcher("Authorization"), new QueryParamPresenceRequestMatcher("access_token")});

    public KeycloakAuthenticationProcessingFilter(AuthenticationManager authenticationManager) {
        super(authenticationManager, DEFAULT_REQUEST_MATCHER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        KeycloakPrincipal keycloakPrincipal;
        if (Log.isDebugEnabled((String)"geonetwork.security")) {
            try {
                Log.debug((String)"geonetwork.security", (Object)("Performing Keycloak auth check. Existing auth is " + SecurityContextHolder.getContext().getAuthentication()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((keycloakPrincipal = (KeycloakPrincipal)authResult.getPrincipal()) != null) {
            String username = "UNIDENTIFIED";
            try {
                UserDetails userDetails = this.keycloakUserUtils.getUserDetails(keycloakPrincipal.getKeycloakSecurityContext().getToken(), true);
                if (userDetails != null) {
                    username = userDetails.getUsername();
                    if (Log.isDebugEnabled((String)"geonetwork.security")) {
                        Log.debug((String)"geonetwork.security", (Object)("Keycloak user found " + userDetails.getUsername() + " with authorities: " + userDetails.getAuthorities()));
                    }
                    SecurityContext context = SecurityContextHolder.createEmptyContext();
                    context.setAuthentication(authResult);
                    SecurityContextHolder.setContext((SecurityContext)context);
                    Log.info((String)"geonetwork.security", (Object)("User '" + userDetails.getUsername() + "' authenticated via Keycloak"));
                    if (((KeycloakAuthenticationToken)authResult).isInteractive()) {
                        if (this.requestCache != null) {
                            String redirect = null;
                            SavedRequest savedReq = this.requestCache.getRequest(request, response);
                            if (savedReq != null) {
                                redirect = savedReq.getRedirectUrl();
                                Log.debug((String)"geonetwork.security", (Object)("Found saved request location: " + redirect));
                            } else {
                                Log.debug((String)"geonetwork.security", (Object)"No saved request found");
                            }
                            if (redirect != null) {
                                Log.info((String)"geonetwork.security", (Object)("Redirecting to " + redirect));
                                this.requestCache.removeRequest(request, response);
                                response.sendRedirect(redirect);
                            }
                        } else {
                            Map<String, List<String>> qsMap = KeycloakAuthenticationProcessingFilter.splitQueryString(request.getQueryString());
                            if (qsMap.containsKey("redirectUrl")) {
                                URI redirectUri = new URI(qsMap.get("redirectUrl").get(0));
                                if (redirectUri != null && !redirectUri.isAbsolute()) {
                                    response.sendRedirect(redirectUri.toString());
                                } else {
                                    Log.warning((String)"geonetwork.security", (Object)("Failed to perform login redirect to '" + qsMap.get("redirectUrl").get(0) + "'. Redirected to context home"));
                                    response.sendRedirect(request.getContextPath());
                                }
                            } else {
                                response.sendRedirect(request.getContextPath());
                            }
                        }
                    } else {
                        try {
                            chain.doFilter((ServletRequest)request, (ServletResponse)response);
                        }
                        finally {
                            SecurityContextHolder.clearContext();
                        }
                    }
                    String localeString = keycloakPrincipal.getKeycloakSecurityContext().getToken().getLocale();
                    if (!StringUtils.isEmpty((CharSequence)localeString)) {
                        try {
                            try {
                                response.setLocale(new Locale.Builder().setLanguageTag(localeString).build());
                            }
                            catch (IllformedLocaleException e) {
                                response.setLocale(LocaleUtils.toLocale((String)localeString));
                            }
                        }
                        catch (IllegalArgumentException e) {
                            Log.warning((String)"geonetwork.security", (Object)("Unable to parse keycloak locale " + localeString + " for user " + username + ": " + e.getMessage()));
                        }
                    }
                }
                if (this.eventPublisher != null) {
                    this.eventPublisher.publishEvent((ApplicationEvent)new InteractiveAuthenticationSuccessEvent(authResult, ((Object)((Object)this)).getClass()));
                }
                return;
            }
            catch (Exception ex) {
                Log.warning((String)"geonetwork.security", (Object)("Error during Keycloak login for user " + username + ": " + ex.getMessage()), (Throwable)ex);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public RequestCache getRequestCache() {
        return this.requestCache;
    }

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }

    private static Map<String, List<String>> splitQueryString(String queryString) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, List<String>> query_pairs = new LinkedHashMap<String, List<String>>();
        for (String pair : pairs = queryString.split("&")) {
            String key;
            int idx = pair.indexOf("=");
            String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            if (!query_pairs.containsKey(key)) {
                query_pairs.put(key, new LinkedList());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
            ((List)query_pairs.get(key)).add(value);
        }
        return query_pairs;
    }
}

