/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.openid;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.FormContentProvider;
import org.eclipse.jetty.security.openid.JwtDecoder;
import org.eclipse.jetty.security.openid.OpenIdConfiguration;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class OpenIdCredentials
implements Serializable {
    private static final Logger LOG = Log.getLogger(OpenIdCredentials.class);
    private static final long serialVersionUID = 4766053233370044796L;
    private final String redirectUri;
    private final OpenIdConfiguration configuration;
    private String authCode;
    private Map<String, Object> response;
    private Map<String, Object> claims;

    public OpenIdCredentials(String authCode, String redirectUri, OpenIdConfiguration configuration) {
        this.authCode = authCode;
        this.redirectUri = redirectUri;
        this.configuration = configuration;
    }

    public String getUserId() {
        return (String)this.claims.get("sub");
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public Map<String, Object> getResponse() {
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redeemAuthCode(HttpClient httpClient) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("redeemAuthCode() {}", new Object[]{this});
        }
        if (this.authCode != null) {
            try {
                String idToken;
                this.response = this.claimAuthCode(httpClient, this.authCode);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("response: {}", new Object[]{this.response});
                }
                if ((idToken = (String)this.response.get("id_token")) == null) {
                    throw new IllegalArgumentException("no id_token");
                }
                String accessToken = (String)this.response.get("access_token");
                if (accessToken == null) {
                    throw new IllegalArgumentException("no access_token");
                }
                String tokenType = (String)this.response.get("token_type");
                if (!"Bearer".equalsIgnoreCase(tokenType)) {
                    throw new IllegalArgumentException("invalid token_type");
                }
                this.claims = JwtDecoder.decode(idToken);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("claims {}", new Object[]{this.claims});
                }
                this.validateClaims();
            }
            finally {
                this.authCode = null;
            }
        }
    }

    private void validateClaims() {
        if (!this.configuration.getIssuer().equals(this.claims.get("iss"))) {
            throw new IllegalArgumentException("Issuer Identifier MUST exactly match the iss Claim");
        }
        this.validateAudience();
        Object azp = this.claims.get("azp");
        if (azp != null && !this.configuration.getClientId().equals(azp)) {
            throw new IllegalArgumentException("Authorized party claim value should be the client_id");
        }
    }

    private void validateAudience() {
        boolean isValidType;
        Object aud = this.claims.get("aud");
        String clientId = this.configuration.getClientId();
        boolean isString = aud instanceof String;
        boolean isList = aud instanceof Object[];
        boolean bl = isValidType = isString || isList;
        if (isString && !clientId.equals(aud)) {
            throw new IllegalArgumentException("Audience Claim MUST contain the client_id value");
        }
        if (isList) {
            if (!Arrays.asList((Object[])aud).contains(clientId)) {
                throw new IllegalArgumentException("Audience Claim MUST contain the client_id value");
            }
            if (this.claims.get("azp") == null) {
                throw new IllegalArgumentException("A multi-audience ID token needs to contain an azp claim");
            }
        } else if (!isValidType) {
            throw new IllegalArgumentException("Audience claim was not valid");
        }
    }

    public boolean isExpired() {
        if (this.authCode != null || this.claims == null) {
            return true;
        }
        long expiry = (Long)this.claims.get("exp");
        long currentTimeSeconds = (long)((float)System.currentTimeMillis() / 1000.0f);
        if (currentTimeSeconds > expiry) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("OpenId Credentials expired {}", new Object[]{this});
            }
            return true;
        }
        return false;
    }

    private Map<String, Object> claimAuthCode(HttpClient httpClient, String authCode) throws Exception {
        Object parsedResponse;
        Fields fields = new Fields();
        fields.add("code", authCode);
        fields.add("client_id", this.configuration.getClientId());
        fields.add("client_secret", this.configuration.getClientSecret());
        fields.add("redirect_uri", this.redirectUri);
        fields.add("grant_type", "authorization_code");
        FormContentProvider formContentProvider = new FormContentProvider(fields);
        Request request = httpClient.POST(this.configuration.getTokenEndpoint()).content((ContentProvider)formContentProvider).timeout(10L, TimeUnit.SECONDS);
        ContentResponse response = request.send();
        String responseBody = response.getContentAsString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Authentication response: {}", new Object[]{responseBody});
        }
        if (!((parsedResponse = JSON.parse((String)responseBody)) instanceof Map)) {
            throw new IllegalStateException("Malformed response from OpenID Provider");
        }
        return (Map)parsedResponse;
    }
}

