/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.impl.ElementNameStreamingParserHandler;
import org.geotools.xsd.impl.StreamingParserHandler;
import org.geotools.xsd.impl.TypeStreamingParserHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StreamingParser {
    private StreamingParserHandler handler;
    private SAXParser parser;
    private InputStream input;
    private Thread thread;

    public StreamingParser(Configuration configuration, InputStream input, Class type) throws ParserConfigurationException, SAXException {
        this(configuration, input, new TypeStreamingParserHandler(configuration, type));
    }

    public StreamingParser(Configuration configuration, InputStream input, QName elementName) throws ParserConfigurationException, SAXException {
        this(configuration, input, new ElementNameStreamingParserHandler(configuration, elementName));
    }

    public StreamingParser(Configuration configuration, InputStream input, String xpath) throws ParserConfigurationException, SAXException {
        this(configuration, input, StreamingParser.createJXpathStreamingParserHandler(configuration, xpath));
    }

    static StreamingParserHandler createJXpathStreamingParserHandler(Configuration configuration, String xpath) throws ParserConfigurationException {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.geotools.xsd.impl.jxpath.JXPathStreamingParserHandler");
        }
        catch (ClassNotFoundException e) {
            throw (ParserConfigurationException)new ParserConfigurationException().initCause(e);
        }
        try {
            Constructor<?> c = clazz.getConstructor(Configuration.class, String.class);
            return (StreamingParserHandler)c.newInstance(configuration, xpath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected StreamingParser(Configuration configuration, InputStream input, StreamingParserHandler handler) throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        this.parser = spf.newSAXParser();
        this.handler = handler;
        this.input = input;
    }

    public Object parse() {
        if (this.thread == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        StreamingParser.this.parser.parse(StreamingParser.this.input, (DefaultHandler)StreamingParser.this.handler);
                    }
                    catch (Exception e) {
                        StreamingParser.this.handler.getBuffer().close();
                        throw new RuntimeException(e);
                    }
                }
            };
            this.thread = new Thread(runnable);
            this.thread.start();
        }
        return this.handler.getBuffer().get();
    }
}

