/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.util.Objects;
import org.fao.geonet.utils.ResolverRewriteDirective;

public class PrefixUrlRewrite
implements ResolverRewriteDirective {
    private final String prefix;
    private final String replacement;

    public PrefixUrlRewrite(String prefix, String replacement) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(replacement);
        this.prefix = prefix;
        this.replacement = replacement;
    }

    @Override
    public boolean appliesTo(String href) {
        return href.startsWith(this.prefix);
    }

    @Override
    public String rewrite(String href) {
        return this.replacement + href.substring(this.prefix.length());
    }

    @Override
    public Object getKey() {
        return this.prefix;
    }
}

