/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.fao.geonet.Constants;
import org.fao.geonet.utils.IO;

public class ZipUtil {
    public static void extract(Path zipFile, Path toDir) throws IOException, URISyntaxException {
        try (FileSystem fs = ZipUtil.openZipFs(zipFile);){
            ZipUtil.extract(fs, toDir);
        }
    }

    public static void extract(FileSystem zipFile, Path toDir) throws IOException {
        Files.createDirectories(toDir, new FileAttribute[0]);
        for (Path root : zipFile.getRootDirectories()) {
            DirectoryStream<Path> paths = Files.newDirectoryStream(root);
            Throwable throwable = null;
            try {
                for (Path path : paths) {
                    Path fileName = path.getFileName();
                    if (fileName == null) continue;
                    IO.copyDirectoryOrFile(path, toDir.resolve(fileName.toString()), false);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (paths == null) continue;
                if (throwable != null) {
                    try {
                        paths.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                paths.close();
            }
        }
    }

    public static FileSystem openZipFs(Path path) throws IOException, URISyntaxException {
        try {
            URI uri = new URI("jar:" + path.toUri().toString());
            return ZipUtil.getOrCreateZipFs(uri);
        }
        catch (Throwable e) {
            try {
                URI uri = new URI("jar:" + URLDecoder.decode(path.toUri().toString(), Constants.ENCODING));
                return ZipUtil.getOrCreateZipFs(uri);
            }
            catch (Throwable e2) {
                URI uri = new URI("jar:" + URLEncoder.encode(path.toUri().toString(), Constants.ENCODING));
                return ZipUtil.getOrCreateZipFs(uri);
            }
        }
    }

    private static FileSystem getOrCreateZipFs(URI uri) throws IOException {
        try {
            return FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException e) {
            return FileSystems.newFileSystem(uri, Collections.singletonMap("create", String.valueOf(false)));
        }
    }

    public static FileSystem createZipFs(Path path) throws IOException, URISyntaxException {
        Files.deleteIfExists(path);
        URI uri = new URI("jar:" + path.toUri());
        return FileSystems.newFileSystem(uri, Collections.singletonMap("create", String.valueOf(true)));
    }
}

