/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.measure.Unit;
import org.geotools.metadata.i18n.Errors;
import org.geotools.parameter.AbstractParameter;
import org.geotools.parameter.AbstractParameterDescriptor;
import org.geotools.parameter.FloatParameter;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.util.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.CodeList;

public class DefaultParameterDescriptor<T>
extends AbstractParameterDescriptor
implements ParameterDescriptor<T> {
    private static final long serialVersionUID = -295668622297737705L;
    private final Class<T> valueClass;
    private final Set<T> validValues;
    private final T defaultValue;
    private final Comparable<T> minimum;
    private final Comparable<T> maximum;
    private final Unit<?> unit;

    public DefaultParameterDescriptor(ParameterDescriptor<T> descriptor) {
        super((GeneralParameterDescriptor)descriptor);
        this.valueClass = descriptor.getValueClass();
        this.validValues = descriptor.getValidValues();
        this.defaultValue = descriptor.getDefaultValue();
        this.minimum = descriptor.getMinimumValue();
        this.maximum = descriptor.getMaximumValue();
        this.unit = descriptor.getUnit();
    }

    public DefaultParameterDescriptor(String name, Class<T> valueClass, T[] validValues, T defaultValue) {
        this(Collections.singletonMap("name", name), valueClass, validValues, defaultValue, null, null, null, true);
    }

    public DefaultParameterDescriptor(Citation authority, String name, Class<T> valueClass, T[] validValues, T defaultValue, Comparable<T> minimum, Comparable<T> maximum, Unit<?> unit, boolean required) {
        this(Collections.singletonMap("name", new NamedIdentifier(authority, name)), valueClass, validValues, defaultValue, minimum, maximum, unit, required);
    }

    public DefaultParameterDescriptor(Map<String, ?> properties, Class<T> valueClass, T[] validValues, T defaultValue, Comparable<T> minimum, Comparable<T> maximum, Unit<?> unit, boolean required) {
        this(properties, required, valueClass, validValues, defaultValue, minimum, maximum, unit);
    }

    private DefaultParameterDescriptor(Map<String, ?> properties, boolean required, Class<T> valueClass, T[] validValues, T defaultValue, Comparable<T> minimum, Comparable<T> maximum, Unit<?> unit) {
        super(properties, required ? 1 : 0, 1);
        this.valueClass = valueClass;
        this.defaultValue = defaultValue;
        this.minimum = minimum;
        this.maximum = maximum;
        this.unit = unit;
        DefaultParameterDescriptor.ensureNonNull("valueClass", valueClass);
        AbstractParameter.ensureValidClass(valueClass, defaultValue);
        AbstractParameter.ensureValidClass(valueClass, minimum);
        AbstractParameter.ensureValidClass(valueClass, maximum);
        if (minimum != null && maximum != null && minimum.compareTo(valueClass.cast(maximum)) > 0) {
            throw new IllegalArgumentException(Errors.format((int)14, minimum, maximum));
        }
        if (validValues != null) {
            HashSet<T> valids = new HashSet<T>(Math.max(validValues.length * 4 / 3 + 1, 8), 0.75f);
            for (int i = 0; i < validValues.length; ++i) {
                T value = validValues[i];
                AbstractParameter.ensureValidClass(valueClass, value);
                valids.add(value);
            }
            this.validValues = Collections.unmodifiableSet(valids);
        } else {
            this.validValues = null;
        }
        if (defaultValue != null) {
            Parameter.ensureValidValue(this, defaultValue);
        }
    }

    public static DefaultParameterDescriptor<Integer> create(String name, int defaultValue, int minimum, int maximum) {
        return DefaultParameterDescriptor.create(Collections.singletonMap("name", name), defaultValue, minimum, maximum, true);
    }

    public static DefaultParameterDescriptor<Integer> create(Map<String, ?> properties, int defaultValue, int minimum, int maximum, boolean required) {
        return new DefaultParameterDescriptor<Integer>(properties, required, Integer.class, null, defaultValue, minimum == Integer.MIN_VALUE ? null : Integer.valueOf(minimum), maximum == Integer.MAX_VALUE ? null : Integer.valueOf(maximum), null);
    }

    public static DefaultParameterDescriptor<Double> create(String name, double defaultValue, double minimum, double maximum, Unit<?> unit) {
        return DefaultParameterDescriptor.create(Collections.singletonMap("name", name), defaultValue, minimum, maximum, unit, true);
    }

    public static DefaultParameterDescriptor<Double> create(Map<String, ?> properties, double defaultValue, double minimum, double maximum, Unit<?> unit, boolean required) {
        return new DefaultParameterDescriptor<Double>(properties, required, Double.class, null, Double.isNaN(defaultValue) ? null : Double.valueOf(defaultValue), minimum == Double.NEGATIVE_INFINITY ? null : Double.valueOf(minimum), maximum == Double.POSITIVE_INFINITY ? null : Double.valueOf(maximum), unit);
    }

    public static <T> DefaultParameterDescriptor<T> create(String name, CharSequence remarks, Class<T> valueClass, T defaultValue, boolean required) {
        Map<String, String> properties;
        Object[] codeList = null;
        if (CodeList.class.isAssignableFrom(valueClass)) {
            try {
                Object[] tmp;
                codeList = tmp = (Object[])valueClass.getMethod("values", null).invoke(null, (Object[])null);
            }
            catch (Exception tmp) {
                // empty catch block
            }
        }
        if (remarks == null) {
            properties = Collections.singletonMap("name", name);
        } else {
            properties = new HashMap<String, String>(4);
            properties.put("name", name);
            properties.put("remarks", (String)remarks);
        }
        return new DefaultParameterDescriptor<Object>(properties, valueClass, codeList, defaultValue, null, null, null, required);
    }

    @Override
    public int getMaximumOccurs() {
        return 1;
    }

    public ParameterValue<T> createValue() {
        if (Double.class.equals(this.valueClass) && this.unit == null) {
            return new FloatParameter(this);
        }
        return new Parameter(this);
    }

    public Class<T> getValueClass() {
        return this.valueClass;
    }

    public Set<T> getValidValues() {
        return this.validValues;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Comparable<T> getMinimumValue() {
        return this.minimum;
    }

    public Comparable<T> getMaximumValue() {
        return this.maximum;
    }

    public Unit<?> getUnit() {
        return this.unit;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            if (!(compareMetadata || this.nameMatches(object.getName().getCode()) || DefaultParameterDescriptor.nameMatches((IdentifiedObject)object, this.getName().getCode()))) {
                return false;
            }
            DefaultParameterDescriptor that = (DefaultParameterDescriptor)object;
            return Utilities.equals(this.validValues, that.validValues) && Utilities.equals(this.defaultValue, that.defaultValue) && Utilities.equals(this.minimum, that.minimum) && Utilities.equals(this.maximum, that.maximum) && Utilities.equals(this.unit, that.unit);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = super.hashCode() * 37 + this.valueClass.hashCode();
        if (this.defaultValue != null) {
            code += 37 * this.defaultValue.hashCode();
        }
        if (this.minimum != null) {
            code += 1369 * this.minimum.hashCode();
        }
        if (this.maximum != null) {
            code += 50653 * this.maximum.hashCode();
        }
        if (this.unit != null) {
            code += this.unit.hashCode();
        }
        return code;
    }
}

