/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.handlers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.inject.Inject;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.handlers.AWSClientErrorRetryHandler;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;

public class SQSErrorRetryHandler
extends AWSClientErrorRetryHandler {
    private final long retryInterval;
    private final int maxTries;

    @Inject
    public SQSErrorRetryHandler(AWSUtils utils, BackoffLimitedRetryHandler backoffLimitedRetryHandler, @ClientError Set<String> retryableCodes, @Named(value="jclouds.sqs.create-queue.max-retries") int maxTries, @Named(value="jclouds.sqs.create-queue.retry-interval") long retryInterval) {
        super(utils, backoffLimitedRetryHandler, retryableCodes);
        this.maxTries = maxTries;
        this.retryInterval = retryInterval;
    }

    @VisibleForTesting
    public boolean shouldRetryRequestOnError(HttpCommand command, HttpResponse response, AWSError error) {
        if ("AWS.SimpleQueueService.QueueDeletedRecently".equals(error.getCode())) {
            if (command.incrementFailureCount() - 1 < this.maxTries) {
                Uninterruptibles.sleepUninterruptibly((long)this.retryInterval, (TimeUnit)TimeUnit.MILLISECONDS);
                return true;
            }
            return false;
        }
        return super.shouldRetryRequestOnError(command, response, error);
    }
}

