/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azureblob.blobstore.functions.BlobMetadataToBlobProperties;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.io.Payload;

@Singleton
public class BlobToAzureBlob
implements Function<Blob, AzureBlob> {
    private final BlobMetadataToBlobProperties blob2ObjectMd;
    private final AzureBlob.Factory objectProvider;

    @Inject
    BlobToAzureBlob(BlobMetadataToBlobProperties blob2ObjectMd, AzureBlob.Factory objectProvider) {
        this.blob2ObjectMd = blob2ObjectMd;
        this.objectProvider = objectProvider;
    }

    public AzureBlob apply(Blob from) {
        if (from == null) {
            return null;
        }
        AzureBlob object = this.objectProvider.create(this.blob2ObjectMd.apply((BlobMetadata)from.getMetadata()));
        object.setPayload((Payload)Preconditions.checkNotNull((Object)from.getPayload(), (Object)("payload: " + from)));
        object.setAllHeaders((Multimap<String, String>)from.getAllHeaders());
        return object;
    }
}

