/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.rollup.job.config;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.client.rollup.job.config.GroupConfig;
import org.elasticsearch.client.rollup.job.config.MetricConfig;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

public class RollupJobConfig
implements Validatable,
ToXContentObject {
    private static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueSeconds((long)20L);
    private static final String ID = "id";
    private static final String TIMEOUT = "timeout";
    private static final String CRON = "cron";
    private static final String PAGE_SIZE = "page_size";
    private static final String INDEX_PATTERN = "index_pattern";
    private static final String ROLLUP_INDEX = "rollup_index";
    private final String id;
    private final String indexPattern;
    private final String rollupIndex;
    private final GroupConfig groupConfig;
    private final List<MetricConfig> metricsConfig;
    private final TimeValue timeout;
    private final String cron;
    private final int pageSize;
    private static final ConstructingObjectParser<RollupJobConfig, String> PARSER = new ConstructingObjectParser("rollup_job_config", true, (args, optionalId) -> {
        String id = args[0] != null ? (String)args[0] : optionalId;
        String indexPattern = (String)args[1];
        String rollupIndex = (String)args[2];
        GroupConfig groupConfig = (GroupConfig)args[3];
        List metricsConfig = (List)args[4];
        TimeValue timeout = (TimeValue)args[5];
        String cron = (String)args[6];
        int pageSize = (Integer)args[7];
        return new RollupJobConfig(id, indexPattern, rollupIndex, cron, pageSize, groupConfig, metricsConfig, timeout);
    });

    public RollupJobConfig(String id, String indexPattern, String rollupIndex, String cron, int pageSize, GroupConfig groupConfig, List<MetricConfig> metricsConfig, @Nullable TimeValue timeout) {
        this.id = id;
        this.indexPattern = indexPattern;
        this.rollupIndex = rollupIndex;
        this.groupConfig = groupConfig;
        this.metricsConfig = metricsConfig != null ? metricsConfig : Collections.emptyList();
        this.timeout = timeout != null ? timeout : DEFAULT_TIMEOUT;
        this.cron = cron;
        this.pageSize = pageSize;
    }

    @Override
    public Optional<ValidationException> validate() {
        Optional<ValidationException> groupValidationErrors;
        ValidationException validationException = new ValidationException();
        if (this.id == null || this.id.isEmpty()) {
            validationException.addValidationError("Id must be a non-null, non-empty string");
        }
        if (this.indexPattern == null || this.indexPattern.isEmpty()) {
            validationException.addValidationError("Index pattern must be a non-null, non-empty string");
        } else if (Regex.isMatchAllPattern((String)this.indexPattern)) {
            validationException.addValidationError("Index pattern must not match all indices (as it would match it's own rollup index");
        } else if (this.indexPattern != null && this.indexPattern.equals(this.rollupIndex)) {
            validationException.addValidationError("Rollup index may not be the same as the index pattern");
        } else if (Regex.isSimpleMatchPattern((String)this.indexPattern) && Regex.simpleMatch((String)this.indexPattern, (String)this.rollupIndex)) {
            validationException.addValidationError("Index pattern would match rollup index name which is not allowed");
        }
        if (this.rollupIndex == null || this.rollupIndex.isEmpty()) {
            validationException.addValidationError("Rollup index must be a non-null, non-empty string");
        }
        if (this.cron == null || this.cron.isEmpty()) {
            validationException.addValidationError("Cron schedule must be a non-null, non-empty string");
        }
        if (this.pageSize <= 0) {
            validationException.addValidationError("Page size is mandatory and  must be a positive long");
        }
        if (this.groupConfig == null && (this.metricsConfig == null || this.metricsConfig.isEmpty())) {
            validationException.addValidationError("At least one grouping or metric must be configured");
        }
        if (this.groupConfig != null && (groupValidationErrors = this.groupConfig.validate()) != null && groupValidationErrors.isPresent()) {
            validationException.addValidationErrors(groupValidationErrors.get());
        }
        if (this.metricsConfig != null) {
            for (MetricConfig metricConfig : this.metricsConfig) {
                Optional<ValidationException> metricsValidationErrors = metricConfig.validate();
                if (metricsValidationErrors == null || !metricsValidationErrors.isPresent()) continue;
                validationException.addValidationErrors(metricsValidationErrors.get());
            }
        }
        if (validationException.validationErrors().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(validationException);
    }

    public String getId() {
        return this.id;
    }

    public GroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    public List<MetricConfig> getMetricsConfig() {
        return this.metricsConfig;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public String getIndexPattern() {
        return this.indexPattern;
    }

    public String getRollupIndex() {
        return this.rollupIndex;
    }

    public String getCron() {
        return this.cron;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID, this.id);
        builder.field(INDEX_PATTERN, this.indexPattern);
        builder.field(ROLLUP_INDEX, this.rollupIndex);
        builder.field(CRON, this.cron);
        if (this.groupConfig != null) {
            builder.field("groups", (ToXContent)this.groupConfig);
        }
        if (this.metricsConfig != null) {
            builder.startArray("metrics");
            for (MetricConfig metric : this.metricsConfig) {
                metric.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.timeout != null) {
            builder.field(TIMEOUT, this.timeout.getStringRep());
        }
        builder.field(PAGE_SIZE, this.pageSize);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RollupJobConfig that = (RollupJobConfig)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.indexPattern, that.indexPattern) && Objects.equals(this.rollupIndex, that.rollupIndex) && Objects.equals(this.cron, that.cron) && Objects.equals(this.groupConfig, that.groupConfig) && Objects.equals(this.metricsConfig, that.metricsConfig) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.pageSize, that.pageSize);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.indexPattern, this.rollupIndex, this.cron, this.groupConfig, this.metricsConfig, this.timeout, this.pageSize);
    }

    public static RollupJobConfig fromXContent(XContentParser parser, @Nullable String optionalJobId) throws IOException {
        return (RollupJobConfig)PARSER.parse(parser, (Object)optionalJobId);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(ID, new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(INDEX_PATTERN, new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(ROLLUP_INDEX, new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> GroupConfig.fromXContent(p), new ParseField("groups", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> MetricConfig.fromXContent(p), new ParseField("metrics", new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue((String)p.textOrNull(), (String)TIMEOUT), new ParseField(TIMEOUT, new String[0]), ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(CRON, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(PAGE_SIZE, new String[0]));
    }
}

