/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;

public class SyncedFlushResponse
implements ToXContentObject {
    public static final String SHARDS_FIELD = "_shards";
    private ShardCounts totalCounts;
    private Map<String, IndexResult> indexResults;

    SyncedFlushResponse(ShardCounts totalCounts, Map<String, IndexResult> indexResults) {
        this.totalCounts = new ShardCounts(totalCounts.total, totalCounts.successful, totalCounts.failed);
        this.indexResults = Collections.unmodifiableMap(indexResults);
    }

    public int totalShards() {
        return this.totalCounts.total;
    }

    public int successfulShards() {
        return this.totalCounts.successful;
    }

    public int failedShards() {
        return this.totalCounts.failed;
    }

    public Map<String, IndexResult> getIndexResults() {
        return this.indexResults;
    }

    ShardCounts getShardCounts() {
        return this.totalCounts;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(SHARDS_FIELD);
        this.totalCounts.toXContent(builder, params);
        builder.endObject();
        for (Map.Entry<String, IndexResult> entry : this.indexResults.entrySet()) {
            String indexName = entry.getKey();
            IndexResult indexResult = entry.getValue();
            builder.startObject(indexName);
            indexResult.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static SyncedFlushResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        ShardCounts totalCounts = null;
        HashMap<String, IndexResult> indexResults = new HashMap<String, IndexResult>();
        XContentLocation startLoc = parser.getTokenLocation();
        while (parser.nextToken().equals((Object)XContentParser.Token.FIELD_NAME)) {
            if (parser.currentName().equals(SHARDS_FIELD)) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                totalCounts = ShardCounts.fromXContent(parser);
                continue;
            }
            String indexName = parser.currentName();
            IndexResult indexResult = IndexResult.fromXContent(parser);
            indexResults.put(indexName, indexResult);
        }
        if (totalCounts != null) {
            return new SyncedFlushResponse(totalCounts, indexResults);
        }
        throw new ParsingException(startLoc, "Unable to reconstruct object. Total counts for shards couldn't be parsed.", new Object[0]);
    }

    public static final class ShardCounts
    implements ToXContentFragment {
        public static final String TOTAL_FIELD = "total";
        public static final String SUCCESSFUL_FIELD = "successful";
        public static final String FAILED_FIELD = "failed";
        private static final ConstructingObjectParser<ShardCounts, Void> PARSER = new ConstructingObjectParser("shardcounts", a -> new ShardCounts((Integer)a[0], (Integer)a[1], (Integer)a[2]));
        private int total;
        private int successful;
        private int failed;

        ShardCounts(int total, int successful, int failed) {
            this.total = total;
            this.successful = successful;
            this.failed = failed;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(TOTAL_FIELD, this.total);
            builder.field(SUCCESSFUL_FIELD, this.successful);
            builder.field(FAILED_FIELD, this.failed);
            return builder;
        }

        public static ShardCounts fromXContent(XContentParser parser) throws IOException {
            return (ShardCounts)PARSER.parse(parser, null);
        }

        public boolean equals(ShardCounts other) {
            if (other != null) {
                return other.total == this.total && other.successful == this.successful && other.failed == this.failed;
            }
            return false;
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(TOTAL_FIELD, new String[0]));
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(SUCCESSFUL_FIELD, new String[0]));
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(FAILED_FIELD, new String[0]));
        }
    }

    public static final class IndexResult
    implements ToXContentFragment {
        public static final String TOTAL_FIELD = "total";
        public static final String SUCCESSFUL_FIELD = "successful";
        public static final String FAILED_FIELD = "failed";
        public static final String FAILURES_FIELD = "failures";
        private static final ConstructingObjectParser<IndexResult, Void> PARSER = new ConstructingObjectParser("indexresult", a -> new IndexResult((Integer)a[0], (Integer)a[1], (Integer)a[2], (List)a[3]));
        private ShardCounts counts;
        private List<ShardFailure> failures;

        IndexResult(int total, int successful, int failed, List<ShardFailure> failures) {
            this.counts = new ShardCounts(total, successful, failed);
            this.failures = failures != null ? Collections.unmodifiableList(failures) : Collections.unmodifiableList(new ArrayList());
        }

        public int totalShards() {
            return this.counts.total;
        }

        public int successfulShards() {
            return this.counts.successful;
        }

        public int failedShards() {
            return this.counts.failed;
        }

        public List<ShardFailure> failures() {
            return this.failures;
        }

        ShardCounts getShardCounts() {
            return this.counts;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.counts.toXContent(builder, params);
            if (this.failures.size() > 0) {
                builder.startArray(FAILURES_FIELD);
                for (ShardFailure failure : this.failures) {
                    failure.toXContent(builder, params);
                }
                builder.endArray();
            }
            return builder;
        }

        public static IndexResult fromXContent(XContentParser parser) throws IOException {
            return (IndexResult)PARSER.parse(parser, null);
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(TOTAL_FIELD, new String[0]));
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(SUCCESSFUL_FIELD, new String[0]));
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(FAILED_FIELD, new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), ShardFailure.PARSER, new ParseField(FAILURES_FIELD, new String[0]));
        }
    }

    public static final class ShardFailure
    implements ToXContentFragment {
        public static String SHARD_ID_FIELD = "shard";
        public static String FAILURE_REASON_FIELD = "reason";
        public static String ROUTING_FIELD = "routing";
        private int shardId;
        private String failureReason;
        private Map<String, Object> routing;
        static final ConstructingObjectParser<ShardFailure, Void> PARSER = new ConstructingObjectParser("shardfailure", a -> new ShardFailure((Integer)a[0], (String)a[1], (Map)a[2]));

        ShardFailure(int shardId, String failureReason, Map<String, Object> routing) {
            this.shardId = shardId;
            this.failureReason = failureReason;
            this.routing = routing != null ? Collections.unmodifiableMap(routing) : Collections.unmodifiableMap(new HashMap());
        }

        public int getShardId() {
            return this.shardId;
        }

        public String getFailureReason() {
            return this.failureReason;
        }

        public Map<String, Object> getRouting() {
            return this.routing;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(SHARD_ID_FIELD, this.shardId);
            builder.field(FAILURE_REASON_FIELD, this.failureReason);
            if (this.routing.size() > 0) {
                builder.field(ROUTING_FIELD, this.routing);
            }
            builder.endObject();
            return builder;
        }

        public static ShardFailure fromXContent(XContentParser parser) throws IOException {
            return (ShardFailure)PARSER.parse(parser, null);
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(SHARD_ID_FIELD, new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(FAILURE_REASON_FIELD, new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, c) -> parser.map(), new ParseField(ROUTING_FIELD, new String[0]));
        }
    }
}

