/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;

public class AuthenticatedURL {
    public static final String AUTH_COOKIE = "hadoop.auth";
    private static final String AUTH_COOKIE_EQ = "hadoop.auth=";
    private static Class<? extends Authenticator> DEFAULT_AUTHENTICATOR = KerberosAuthenticator.class;
    private Authenticator authenticator;

    public static void setDefaultAuthenticator(Class<? extends Authenticator> authenticator) {
        DEFAULT_AUTHENTICATOR = authenticator;
    }

    public static Class<? extends Authenticator> getDefaultAuthenticator() {
        return DEFAULT_AUTHENTICATOR;
    }

    public AuthenticatedURL() {
        this(null);
    }

    public AuthenticatedURL(Authenticator authenticator) {
        try {
            this.authenticator = authenticator != null ? authenticator : DEFAULT_AUTHENTICATOR.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public HttpURLConnection openConnection(URL url, Token token) throws IOException, AuthenticationException {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be NULL");
        }
        if (!url.getProtocol().equalsIgnoreCase("http") && !url.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("url must be for a HTTP or HTTPS resource");
        }
        if (token == null) {
            throw new IllegalArgumentException("token cannot be NULL");
        }
        this.authenticator.authenticate(url, token);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        AuthenticatedURL.injectToken(conn, token);
        return conn;
    }

    public static void injectToken(HttpURLConnection conn, Token token) {
        String t = token.token;
        if (t != null) {
            if (!t.startsWith("\"")) {
                t = "\"" + t + "\"";
            }
            conn.addRequestProperty("Cookie", AUTH_COOKIE_EQ + t);
        }
    }

    public static void extractToken(HttpURLConnection conn, Token token) throws IOException, AuthenticationException {
        if (conn.getResponseCode() == 200) {
            Map<String, List<String>> headers = conn.getHeaderFields();
            List<String> cookies = headers.get("Set-Cookie");
            if (cookies != null) {
                for (String cookie : cookies) {
                    if (!cookie.startsWith(AUTH_COOKIE_EQ)) continue;
                    String value = cookie.substring(AUTH_COOKIE_EQ.length());
                    int separator = value.indexOf(";");
                    if (separator > -1) {
                        value = value.substring(0, separator);
                    }
                    if (value.length() <= 0) continue;
                    token.set(value);
                }
            }
        } else {
            throw new AuthenticationException("Authentication failed, status: " + conn.getResponseCode() + ", message: " + conn.getResponseMessage());
        }
    }

    public static class Token {
        private String token;

        public Token() {
        }

        public Token(String tokenStr) {
            if (tokenStr == null) {
                throw new IllegalArgumentException("tokenStr cannot be null");
            }
            this.set(tokenStr);
        }

        public boolean isSet() {
            return this.token != null;
        }

        void set(String tokenStr) {
            this.token = tokenStr;
        }

        public String toString() {
            return this.token;
        }

        public int hashCode() {
            return this.token != null ? this.token.hashCode() : 0;
        }

        public boolean equals(Object o) {
            boolean eq = false;
            if (o instanceof Token) {
                Token other = (Token)o;
                eq = this.token == null && other.token == null || this.token != null && this.token.equals(other.token);
            }
            return eq;
        }
    }
}

