/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotsService;

public final class FinalizeSnapshotContext
extends ActionListener.Delegating<Tuple<RepositoryData, SnapshotInfo>, Tuple<RepositoryData, SnapshotInfo>> {
    private final ShardGenerations updatedShardGenerations;
    private final long repositoryStateId;
    private final Metadata clusterMetadata;
    private final SnapshotInfo snapshotInfo;
    private final Version repositoryMetaVersion;

    public FinalizeSnapshotContext(ShardGenerations updatedShardGenerations, long repositoryStateId, Metadata clusterMetadata, SnapshotInfo snapshotInfo, Version repositoryMetaVersion, ActionListener<Tuple<RepositoryData, SnapshotInfo>> listener) {
        super(listener);
        this.updatedShardGenerations = updatedShardGenerations;
        this.repositoryStateId = repositoryStateId;
        this.clusterMetadata = clusterMetadata;
        this.snapshotInfo = snapshotInfo;
        this.repositoryMetaVersion = repositoryMetaVersion;
    }

    public long repositoryStateId() {
        return this.repositoryStateId;
    }

    public ShardGenerations updatedShardGenerations() {
        return this.updatedShardGenerations;
    }

    public SnapshotInfo snapshotInfo() {
        return this.snapshotInfo;
    }

    public Version repositoryMetaVersion() {
        return this.repositoryMetaVersion;
    }

    public Metadata clusterMetadata() {
        return this.clusterMetadata;
    }

    public ClusterState updatedClusterState(ClusterState state) {
        return SnapshotsService.stateWithoutSnapshot(state, this.snapshotInfo.snapshot());
    }

    @Override
    public void onResponse(Tuple<RepositoryData, SnapshotInfo> repositoryData) {
        this.delegate.onResponse(repositoryData);
    }
}

