/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.model.Constant;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ValueIterator;
import org.openrdf.sesame.sail.util.EmptyValueIterator;
import org.openrdf.sesame.sail.util.SingleValueIterator;

public class StringConstant
extends Constant {
    protected String _value;

    public StringConstant(String value) {
        this._value = value;
    }

    public void evaluate(RdfSchemaSource rss, TableQueryResultListener listener) throws QueryEvaluationException {
        throw new QueryEvaluationException("Cannot use string constant as top-level query");
    }

    public ValueIterator getResources(RdfSchemaSource rss) {
        if (this._value != null) {
            return new SingleValueIterator((Value)new LiteralImpl(this._value));
        }
        return new EmptyValueIterator();
    }

    public String getValue() {
        return this._value;
    }

    public String getQuery() {
        return "\"" + this._value + "\"";
    }

    public String toString() {
        return "\"" + this._value + "\"";
    }
}

