/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.chef.domain.Resource;

public class CookbookVersionPredicates {
    public static Predicate<CookbookVersion> containsRecipe(String recipe) {
        return CookbookVersionPredicates.containsRecipes((String)Preconditions.checkNotNull((Object)recipe, (Object)"recipe must be defined"));
    }

    public static Predicate<CookbookVersion> containsRecipes(String ... recipes) {
        Preconditions.checkNotNull((Object)recipes, (Object)"recipes must be defined");
        LinkedListMultimap search = LinkedListMultimap.create();
        for (String recipe : recipes) {
            if (recipe.indexOf("::") != -1) {
                Iterable nameRecipe = Splitter.on((String)"::").split((CharSequence)recipe);
                search.put(Iterables.get((Iterable)nameRecipe, (int)0), (Object)((String)Iterables.get((Iterable)nameRecipe, (int)1) + ".rb"));
                continue;
            }
            search.put((Object)recipe, (Object)"default.rb");
        }
        return new Predicate<CookbookVersion>((Multimap)search){
            final /* synthetic */ Multimap val$search;
            {
                this.val$search = multimap;
            }

            public boolean apply(final CookbookVersion cookbookVersion) {
                return this.val$search.containsKey((Object)cookbookVersion.getCookbookName()) && Iterables.any((Iterable)this.val$search.get((Object)cookbookVersion.getCookbookName()), (Predicate)new Predicate<String>(){

                    public boolean apply(final String recipeName) {
                        return Iterables.any(cookbookVersion.getRecipes(), (Predicate)new Predicate<Resource>(){

                            public boolean apply(Resource resource) {
                                return resource.getName().equals(recipeName);
                            }
                        });
                    }
                });
            }

            public String toString() {
                return "containsRecipes(" + this.val$search + ")";
            }
        };
    }
}

