/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.test;

import java.util.Enumeration;
import opendap.dap.Attribute;
import opendap.dap.AttributeTable;
import opendap.dap.DAS;
import opendap.dap.DASException;
import opendap.dap.parser.DASParserTokenManager;
import opendap.dap.parser.ParseException;
import opendap.dap.parser.SimpleCharStream;
import opendap.dap.parser.Token;
import opendap.dap.parser.TokenMgrError;
import opendap.util.Getopts;
import opendap.util.InvalidSwitch;

public class das_test {
    private static final String prompt = "das-test: ";
    private static final String version = "version 0.1";

    private static void usage() {
        System.err.println("usage: das-test [-v] [-s] [-d] [-c] [-p] {< in-file > out-file}");
        System.err.println(" s: Test the DAS scanner.");
        System.err.println(" p: Scan and parse from <in-file>; print to <out-file>.");
        System.err.println(" c: Test building the DAS from code.");
        System.err.println(" v: Print the version of das-test and exit.");
        System.err.println(" d: Print parser debugging information.");
    }

    public static void main(String[] args) {
        boolean parser_test = false;
        boolean scanner_test = false;
        boolean code_test = false;
        try {
            Getopts opts = new Getopts("scpvd", args);
            if (opts.getSwitch((Character)new Character((char)'p')).set) {
                parser_test = true;
            }
            if (opts.getSwitch((Character)new Character((char)'s')).set) {
                scanner_test = true;
            }
            if (opts.getSwitch((Character)new Character((char)'c')).set) {
                code_test = true;
            }
            if (opts.getSwitch((Character)new Character((char)'v')).set) {
                System.err.println("das-test: version 0.1");
                System.exit(0);
            }
        }
        catch (InvalidSwitch e) {
            das_test.usage();
            System.exit(1);
        }
        DAS das = new DAS();
        if (!(parser_test || scanner_test || code_test)) {
            das_test.usage();
            System.exit(1);
        }
        if (parser_test) {
            das_test.parser_driver(das);
        }
        if (scanner_test) {
            das_test.test_scanner();
        }
        if (code_test) {
            das_test.plain_driver(das);
        }
    }

    private static void test_scanner() {
        SimpleCharStream jj_input_stream = new SimpleCharStream(System.in, 1, 1);
        DASParserTokenManager token_source = new DASParserTokenManager(jj_input_stream);
        System.out.print(prompt);
        System.out.flush();
        while (true) {
            Token tok = token_source.getNextToken();
            if (tok.kind == 0) break;
            switch (tok.kind) {
                case 6: {
                    System.out.println("ATTR");
                    break;
                }
                case 7: {
                    System.out.println("ALIAS");
                    break;
                }
                case 8: {
                    System.out.println("BYTE");
                    break;
                }
                case 11: {
                    System.out.println("INT32");
                    break;
                }
                case 14: {
                    System.out.println("FLOAT64");
                    break;
                }
                case 15: {
                    System.out.println("STRING");
                    break;
                }
                case 16: {
                    System.out.println("URL");
                    break;
                }
                case 17: 
                case 18: {
                    System.out.println("WORD=" + tok.image);
                    break;
                }
                default: {
                    System.out.println("Found: " + tok.image);
                }
            }
            System.out.print(prompt);
            System.out.flush();
        }
    }

    private static void parser_driver(DAS das) {
        try {
            das.parse(System.in);
            das.print(System.out);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
            System.err.println("parse() returned: 0");
        }
        catch (DASException e) {
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
            System.err.println("parse() returned: 0");
        }
        catch (TokenMgrError e) {
            System.err.println(e.getMessage());
            System.err.println();
            e.printStackTrace(System.err);
            System.exit(2);
        }
    }

    private static void plain_driver(DAS das) {
        String name = "test";
        AttributeTable atp = new AttributeTable("test");
        das_test.load_attr_table(atp);
        try {
            AttributeTable dummy = das.getAttributeTable(name);
            das.addAttributeTable(name, atp);
        }
        catch (DASException de) {
            System.err.println(de.getMessage());
        }
        name = "test2";
        atp = new AttributeTable("test2");
        das_test.load_attr_table(atp);
        try {
            das.addAttributeTable(name, atp);
        }
        catch (DASException de) {
            System.err.println(de.getMessage());
        }
        das.print(System.out);
    }

    private static void load_attr_table(AttributeTable at) {
        try {
            Enumeration es;
            Attribute a;
            String name;
            at.appendAttribute("month", 10, "Feb");
            at.appendAttribute("month", 10, "Feb");
            at.appendAttribute("month_a", 10, "Jan");
            at.appendAttribute("month_a", 10, "Feb");
            at.appendAttribute("month_a", 10, "Mar");
            at.appendAttribute("Date", 6, "12345");
            at.appendAttribute("day", 6, "01");
            at.appendAttribute("Time", 9, "3.1415");
            System.out.println("Using the Pix:");
            Enumeration e = at.getNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                a = at.getAttribute(name);
                System.out.print(name + " " + a.getTypeString() + " ");
                es = a.getValues();
                while (es.hasMoreElements()) {
                    System.out.print((String)es.nextElement() + " ");
                }
                System.out.println();
            }
            name = "month";
            a = at.getAttribute(name);
            System.out.println("Using String: " + a.getTypeString() + " " + a.getValueAt(0) + " " + a.getValueAt(1));
            System.out.println("Using char *: " + a.getTypeString() + " " + a.getValueAt(0) + " " + a.getValueAt(1));
            at.delAttribute("month");
            System.out.println("After deletion:");
            e = at.getNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                a = at.getAttribute(name);
                System.out.print(name + " " + a.getTypeString() + " ");
                es = a.getValues();
                while (es.hasMoreElements()) {
                    System.out.print((String)es.nextElement() + " ");
                }
                System.out.println();
            }
            at.print(System.out);
            System.out.println("After print:");
            e = at.getNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                a = at.getAttribute(name);
                System.out.print(name + " " + a.getTypeString() + " ");
                es = a.getValues();
                while (es.hasMoreElements()) {
                    System.out.print((String)es.nextElement() + " ");
                }
                System.out.println();
            }
        }
        catch (DASException e) {
            System.err.println(e.getMessage());
        }
    }
}

