/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.index;

import java.util.Date;
import java.util.Set;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.search.index.IndexingList;
import org.fao.geonet.utils.Log;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class IndexingTask
extends QuartzJobBean {
    @Autowired
    protected ConfigurableApplicationContext applicationContext;
    @Autowired
    protected DataManager _dataManager;
    @Autowired
    protected ServiceManager serviceManager;

    private void indexRecords() {
        ApplicationContextHolder.set((ConfigurableApplicationContext)this.applicationContext);
        IndexingList list = (IndexingList)this.applicationContext.getBean(IndexingList.class);
        Set<Integer> metadataIdentifiers = list.getIdentifiers();
        if (metadataIdentifiers.size() > 0) {
            if (Log.isDebugEnabled((String)"geonetwork.index")) {
                Log.debug((String)"geonetwork.index", (Object)("Indexing task / List of records to index: " + metadataIdentifiers.toString() + "."));
            }
            for (Integer metadataIdentifier : metadataIdentifiers) {
                try {
                    this._dataManager.indexMetadata(String.valueOf(metadataIdentifier), false);
                }
                catch (Exception e) {
                    Log.error((String)"geonetwork.index", (Object)("Indexing task / An error happens indexing the metadata " + metadataIdentifier + ". Error: " + e.getMessage()), (Throwable)e);
                }
            }
            ((EsSearchManager)this.applicationContext.getBean(EsSearchManager.class)).forceIndexChanges();
        }
    }

    protected void executeInternal(JobExecutionContext jobContext) throws JobExecutionException {
        ServiceContext serviceContext = this.serviceManager.createServiceContext("indexing", this.applicationContext);
        serviceContext.setLanguage("eng");
        serviceContext.setAsThreadLocal();
        if (Log.isDebugEnabled((String)"geonetwork.index")) {
            Log.debug((String)"geonetwork.index", (Object)("Indexing task / Start at: " + new Date() + ". Checking if any records need to be indexed ..."));
        }
        this.indexRecords();
    }
}

