/*
 * Decompiled with CFR 0.152.
 */
package jeeves.config.springutil;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;

public class AddAuthenticationProviderPostProcessor
implements BeanPostProcessor {
    private final int addIndex;
    private final AuthenticationProvider providerToAdd;

    public AddAuthenticationProviderPostProcessor(int addIndex, AuthenticationProvider providerToAdd) {
        this.addIndex = addIndex;
        this.providerToAdd = providerToAdd;
    }

    public AddAuthenticationProviderPostProcessor(AuthenticationProvider providerToAdd) {
        this(-1, providerToAdd);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (beanName.equals("authenticationManager")) {
            ProviderManager authManager = (ProviderManager)bean;
            if (this.addIndex < 0) {
                authManager.getProviders().add(this.providerToAdd);
            } else {
                authManager.getProviders().add(this.addIndex, this.providerToAdd);
            }
        }
        return bean;
    }
}

