/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.harvest.AbstractAligner;
import org.fao.geonet.kernel.harvest.harvester.AbstractParams;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.GroupMapper;
import org.fao.geonet.kernel.harvest.harvester.Privileges;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAligner<P extends AbstractParams>
extends AbstractAligner<P> {
    private static Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.harvester");
    public final AtomicBoolean cancelMonitor;

    public BaseAligner(AtomicBoolean cancelMonitor) {
        this.cancelMonitor = cancelMonitor;
    }

    public void addCategories(AbstractMetadata metadata, Iterable<String> categories, CategoryMapper localCateg, ServiceContext context, String serverCategory, boolean saveMetadata) {
        MetadataCategoryRepository metadataCategoryRepository = (MetadataCategoryRepository)context.getBean(MetadataCategoryRepository.class);
        HashMap<String, MetadataCategory> nameToCategoryMap = new HashMap<String, MetadataCategory>();
        for (MetadataCategory metadataCategory : metadataCategoryRepository.findAll()) {
            nameToCategoryMap.put("" + metadataCategory.getId(), metadataCategory);
        }
        for (String catId : categories) {
            String name = localCateg.getName(catId);
            if (name == null) {
                LOGGER.debug("    - Skipping removed category with id:{}", (Object)catId);
                continue;
            }
            LOGGER.debug("    - Setting category : {}", (Object)name);
            MetadataCategory metadataCategory = (MetadataCategory)nameToCategoryMap.get(catId);
            if (metadataCategory != null) {
                metadata.getCategories().add(metadataCategory);
                continue;
            }
            LOGGER.warn("Unable to map category: {} ({}) to a category in Geonetwork", (Object)catId, (Object)name);
        }
        if (serverCategory != null) {
            String catId = localCateg.getID(serverCategory);
            if (catId == null) {
                LOGGER.debug("    - Skipping removed category :{}", (Object)serverCategory);
            } else {
                MetadataCategory metadataCategory;
                metadataCategory = (MetadataCategory)nameToCategoryMap.get(catId);
                if (metadataCategory != null) {
                    metadata.getCategories().add(metadataCategory);
                } else {
                    LOGGER.warn("Unable to map category: {} to a category in Geonetwork", (Object)catId);
                }
            }
        }
        if (saveMetadata) {
            ((IMetadataManager)context.getBean(IMetadataManager.class)).save(metadata);
        }
    }

    public void addPrivileges(String id, Iterable<Privileges> privilegesIterable, GroupMapper localGroups, ServiceContext context) throws Exception {
        OperationAllowedRepository operationAllowedRepository = (OperationAllowedRepository)context.getBean(OperationAllowedRepository.class);
        DataManager dataManager = (DataManager)context.getBean(DataManager.class);
        if (!this.params.isIfRecordExistAppendPrivileges()) {
            operationAllowedRepository.deleteAllByMetadataId(Integer.parseInt(id));
        }
        for (Privileges priv : privilegesIterable) {
            String name = localGroups.getName(priv.getGroupId());
            if (name == null) {
                LOGGER.debug("    - Skipping removed group with id:{}", (Object)priv.getGroupId());
                continue;
            }
            LOGGER.debug("    - Setting privileges for group : {}", (Object)name);
            for (int opId : priv.getOperations()) {
                name = dataManager.getAccessManager().getPrivilegeName(opId);
                if (name == null) continue;
                LOGGER.debug("       --> Operation: {}", (Object)name);
                dataManager.setOperation(context, id, priv.getGroupId(), opId + "");
            }
        }
    }
}

