/*
 * Decompiled with CFR 0.152.
 */
package au.com.objectix.jgridshift.jca;

import au.com.objectix.jgridshift.jca.GridShiftConnectionImpl;
import au.com.objectix.jgridshift.jca.GridShiftInteractionSpec;
import au.com.objectix.jgridshift.jca.GridShiftRecord;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;

public class InteractionImpl
implements Interaction {
    private GridShiftConnectionImpl c;

    public InteractionImpl(GridShiftConnectionImpl c) {
        this.c = c;
    }

    public void close() throws ResourceException {
        this.c = null;
    }

    public Connection getConnection() {
        return this.c;
    }

    public boolean execute(InteractionSpec ispec, Record input, Record output) throws ResourceException {
        if (this.c == null) {
            throw new ResourceException("Interaction closed");
        }
        try {
            if (ispec instanceof GridShiftInteractionSpec) {
                if (input instanceof GridShiftRecord) {
                    if (output instanceof GridShiftRecord) {
                        GridShiftRecord clone = (GridShiftRecord)input.clone();
                        boolean complete = false;
                        complete = ((GridShiftInteractionSpec)ispec).isForward() ? this.c.gridShiftForward(clone) : this.c.gridShiftReverse(clone);
                        if (complete) {
                            ((GridShiftRecord)output).copy(clone);
                        }
                        return complete;
                    }
                    throw new ResourceException("Output Record is not a GridShift object");
                }
                throw new ResourceException("Input Record is not a GridShift object");
            }
            throw new ResourceException("Interaction Spec is not a GridShiftInteractionSpec object");
        }
        catch (Exception e) {
            ResourceException re = new ResourceException("GridShift Failed: " + e.getMessage());
            re.setLinkedException(e);
            throw re;
        }
    }

    public Record execute(InteractionSpec ispec, Record input) throws ResourceException {
        if (this.c == null) {
            throw new ResourceException("Interaction closed");
        }
        try {
            if (ispec instanceof GridShiftInteractionSpec) {
                if (input instanceof GridShiftRecord) {
                    GridShiftRecord clone = (GridShiftRecord)input.clone();
                    boolean complete = false;
                    complete = ((GridShiftInteractionSpec)ispec).isForward() ? this.c.gridShiftForward(clone) : this.c.gridShiftReverse(clone);
                    if (complete) {
                        return clone;
                    }
                    return null;
                }
                throw new ResourceException("Input Record is not a GridShift object");
            }
            throw new ResourceException("Interaction Spec is not a GridShiftInteractionSpec object");
        }
        catch (Exception e) {
            ResourceException re = new ResourceException("GridShift Failed: " + e.getMessage());
            re.setLinkedException(e);
            throw re;
        }
    }

    public ResourceWarning getWarnings() throws ResourceException {
        return null;
    }

    public void clearWarnings() throws ResourceException {
    }
}

