/*
 * Decompiled with CFR 0.152.
 */
package au.com.objectix.jgridshift.jca;

import au.com.objectix.jgridshift.GridShift;
import au.com.objectix.jgridshift.jca.ConnectionMetaDataImpl;
import au.com.objectix.jgridshift.jca.GridShiftConnection;
import au.com.objectix.jgridshift.jca.InteractionImpl;
import au.com.objectix.jgridshift.jca.ManagedConnectionImpl;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;

public class GridShiftConnectionImpl
implements GridShiftConnection {
    private static final String CLOSED = "Connection closed";
    private static final String NO_TRANSACTION = "Local transactions not supported";
    private static final String NO_RESULT_SET = "Result sets not supported";
    private ManagedConnectionImpl mc;

    public GridShiftConnectionImpl(ManagedConnectionImpl mc) {
        this.mc = mc;
    }

    void disconnect() {
        this.mc = null;
    }

    public Interaction createInteraction() throws ResourceException {
        if (this.mc != null) {
            return new InteractionImpl(this);
        }
        throw new ResourceException(CLOSED);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException(NO_TRANSACTION);
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        if (this.mc != null) {
            return new ConnectionMetaDataImpl(this.mc.getMetaData());
        }
        throw new ResourceException(CLOSED);
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        throw new NotSupportedException(NO_RESULT_SET);
    }

    public void close() throws ResourceException {
        if (this.mc != null) {
            this.mc.close(this);
        }
        this.mc = null;
    }

    public boolean gridShiftForward(GridShift gs) throws ResourceException {
        return this.mc.gridShiftForward(gs);
    }

    public boolean gridShiftReverse(GridShift gs) throws ResourceException {
        return this.mc.gridShiftReverse(gs);
    }
}

