/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.harvester.wfsfeatures;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.harvester.wfsfeatures.event.WFSHarvesterEvent;
import org.fao.geonet.harvester.wfsfeatures.model.WFSHarvesterParameter;
import org.fao.geonet.harvester.wfsfeatures.worker.EsWFSFeatureIndexer;
import org.fao.geonet.index.es.EsRestClient;
import org.fao.geonet.utils.Log;
import org.geonetwork.messaging.JMSMessager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/{portal}/api/workers/data/wfs/actions"})
@Tag(name="workers", description="Workers related operations")
public class WFSHarvesterApi {
    @Autowired
    private JMSMessager jmsMessager;
    @Autowired
    EsRestClient client;

    @Operation(summary="Index a WFS feature type")
    @RequestMapping(value={"start"}, consumes={"application/json"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public JSONObject indexWfs(@RequestBody WFSHarvesterParameter config) throws Exception {
        JSONObject result = new JSONObject();
        result.put((Object)"success", (Object)true);
        result.put((Object)"indexedFeatures", (Object)this.sendMessage(config));
        return result;
    }

    @Operation(summary="Delete a WFS feature type")
    @RequestMapping(consumes={"*/*"}, produces={"*/*"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public JSONObject deleteWfs(@RequestParam String serviceUrl, @RequestParam String typeName) throws Exception {
        EsWFSFeatureIndexer indexer = (EsWFSFeatureIndexer)ApplicationContextHolder.get().getBean(EsWFSFeatureIndexer.class);
        indexer.deleteFeatures(serviceUrl, typeName, this.client);
        JSONObject result = new JSONObject();
        result.put((Object)"success", (Object)true);
        return result;
    }

    private JSONObject sendMessage(WFSHarvesterParameter parameters) {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        WFSHarvesterEvent event = new WFSHarvesterEvent(appContext, parameters);
        this.jmsMessager.sendMessage("harvest-wfs-features", (ApplicationEvent)event);
        JSONObject j = new JSONObject();
        j.put((Object)"url", (Object)parameters.getUrl());
        j.put((Object)"featureType", (Object)parameters.getTypeName());
        return j;
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={Exception.class})
    public Object exceptionHandler(final Exception exception) {
        Log.error((String)"geonetwork.api", (Object)exception.getMessage(), (Throwable)exception);
        return new HashMap(){
            {
                this.put("result", "failed");
                this.put("type", "file_not_found");
                this.put("message", exception.getClass() + " " + exception.getMessage());
            }
        };
    }
}

