/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.DirectionalPool;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class DirectionalPoolListHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<FluentIterable<DirectionalPool>> {
    private final ImmutableSet.Builder<DirectionalPool> pools = ImmutableSet.builder();

    public FluentIterable<DirectionalPool> getResult() {
        return FluentIterable.from((Iterable)this.pools.build());
    }

    public void startElement(String url, String name, String qName, Attributes attrs) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"DirectionalPoolData")) {
            String tieBreak;
            Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
            DirectionalPool.Builder pool = DirectionalPool.builder().zoneId((String)attributes.get("Zoneid")).id((String)attributes.get("dirpoolid")).dname((String)attributes.get("Pooldname")).name((String)attributes.get("Description"));
            String type = (String)attributes.get("DirPoolType");
            if (type != null) {
                pool.type(DirectionalPool.Type.valueOf(type));
            }
            if ((tieBreak = (String)attributes.get("TieBreak")) != null) {
                pool.tieBreak(DirectionalPool.TieBreak.valueOf(tieBreak));
            }
            this.pools.add((Object)pool.build());
        }
    }
}

