/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public final class PoolRecordSpec {
    private final String description;
    private final String state;
    private final boolean probingEnabled;
    private final boolean allFailEnabled;
    private final int weight;
    private final int failOverDelay;
    private final int threshold;
    private final int ttl;

    private PoolRecordSpec(String description, String state, boolean probingEnabled, boolean allFailEnabled, int weight, int failOverDelay, int threshold, int ttl) {
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
        this.state = (String)Preconditions.checkNotNull((Object)state, (String)"state for %s", (Object[])new Object[]{description});
        this.probingEnabled = probingEnabled;
        this.allFailEnabled = allFailEnabled;
        this.weight = weight;
        Preconditions.checkArgument((weight >= 0 ? 1 : 0) != 0, (String)"weight of %s must be >= 0", (Object[])new Object[]{description});
        this.failOverDelay = failOverDelay;
        Preconditions.checkArgument((failOverDelay >= 0 ? 1 : 0) != 0, (String)"failOverDelay of %s must be >= 0", (Object[])new Object[]{description});
        this.threshold = threshold;
        Preconditions.checkArgument((threshold >= 0 ? 1 : 0) != 0, (String)"threshold of %s must be >= 0", (Object[])new Object[]{description});
        this.ttl = ttl;
        Preconditions.checkArgument((ttl >= 0 ? 1 : 0) != 0, (String)"ttl of %s must be >= 0", (Object[])new Object[]{description});
    }

    public String getDescription() {
        return this.description;
    }

    public String getState() {
        return this.state;
    }

    public boolean isProbingEnabled() {
        return this.probingEnabled;
    }

    public boolean isAllFailEnabled() {
        return this.allFailEnabled;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getFailOverDelay() {
        return this.failOverDelay;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public int getTTL() {
        return this.ttl;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.description, this.state, this.probingEnabled, this.allFailEnabled, this.weight, this.failOverDelay, this.threshold, this.ttl});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PoolRecordSpec that = (PoolRecordSpec)PoolRecordSpec.class.cast(obj);
        return Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal((Object)this.probingEnabled, (Object)that.probingEnabled) && Objects.equal((Object)this.allFailEnabled, (Object)that.allFailEnabled) && Objects.equal((Object)this.weight, (Object)that.weight) && Objects.equal((Object)this.failOverDelay, (Object)that.failOverDelay) && Objects.equal((Object)this.threshold, (Object)that.threshold) && Objects.equal((Object)this.ttl, (Object)that.ttl);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("description", (Object)this.description).add("state", (Object)this.state).add("probingEnabled", this.probingEnabled).add("allFailEnabled", this.allFailEnabled).add("weight", this.weight).add("failOverDelay", this.failOverDelay).add("threshold", this.threshold).add("ttl", this.ttl).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return PoolRecordSpec.builder().from(this);
    }

    public static final class Builder {
        private String description;
        private String state;
        private boolean probingEnabled;
        private boolean allFailEnabled;
        private int weight;
        private int failOverDelay;
        private int threshold;
        private int ttl;

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder probingEnabled(boolean probingEnabled) {
            this.probingEnabled = probingEnabled;
            return this;
        }

        public Builder allFailEnabled(boolean allFailEnabled) {
            this.allFailEnabled = allFailEnabled;
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder failOverDelay(int failOverDelay) {
            this.failOverDelay = failOverDelay;
            return this;
        }

        public Builder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public PoolRecordSpec build() {
            return new PoolRecordSpec(this.description, this.state, this.probingEnabled, this.allFailEnabled, this.weight, this.failOverDelay, this.threshold, this.ttl);
        }

        public Builder from(PoolRecordSpec in) {
            return this.description(in.description).state(in.state).probingEnabled(in.probingEnabled).allFailEnabled(in.allFailEnabled).weight(in.weight).failOverDelay(in.failOverDelay).threshold(in.threshold).ttl(in.ttl);
        }
    }
}

