/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Set;
import org.jclouds.cloudwatch.domain.ComparisonOperator;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.domain.Unit;

@Beta
public class Alarm {
    private final boolean areActionsEnabled;
    private final Set<String> alarmActions;
    private final String alarmARN;
    private final Date alarmConfigurationUpdatedTimestamp;
    private final String alarmDescription;
    private final String alarmName;
    private final ComparisonOperator comparisonOperator;
    private final Set<Dimension> dimensions;
    private final int evaluationPeriods;
    private final Set<String> insufficientDataActions;
    private final String metricName;
    private final String namespace;
    private final Set<String> okActions;
    private final int period;
    private final String stateReason;
    private final Optional<String> stateReasonData;
    private final Date stateUpdatedTimestamp;
    private final State state;
    private final Statistics statistic;
    private final double threshold;
    private final Optional<Unit> unit;

    public Alarm(boolean areActionsEnabled, Set<String> alarmActions, String alarmARN, Date alarmConfigurationUpdatedTimestamp, String alarmDescription, String alarmName, ComparisonOperator comparisonOperator, Set<Dimension> dimensions, int evaluationPeriods, Set<String> insufficientDataActions, String metricName, String namespace, Set<String> okActions, int period, String stateReason, Optional<String> stateReasonData, Date stateUpdatedTimestamp, State state, Statistics statistic, double threshold, Optional<Unit> unit) {
        this.alarmName = (String)Preconditions.checkNotNull((Object)alarmName, (Object)"alarmName");
        this.areActionsEnabled = areActionsEnabled;
        this.alarmActions = (Set)Preconditions.checkNotNull(alarmActions, (String)"alarmActions for %s", (Object[])new Object[]{alarmName});
        this.alarmARN = (String)Preconditions.checkNotNull((Object)alarmARN, (String)"alarmArn for %s", (Object[])new Object[]{alarmName});
        this.alarmConfigurationUpdatedTimestamp = (Date)Preconditions.checkNotNull((Object)alarmConfigurationUpdatedTimestamp, (String)"alarmConfigurationUpdatedTimestamp for %s", (Object[])new Object[]{alarmName});
        this.alarmDescription = (String)Preconditions.checkNotNull((Object)alarmDescription, (String)"alarmDescription for %s", (Object[])new Object[]{alarmName});
        this.comparisonOperator = (ComparisonOperator)((Object)Preconditions.checkNotNull((Object)((Object)comparisonOperator), (String)"comparisonOperator for %s", (Object[])new Object[]{alarmName}));
        Preconditions.checkArgument((comparisonOperator != ComparisonOperator.UNRECOGNIZED ? 1 : 0) != 0, (Object)"comparisonOperator unrecognized");
        this.dimensions = (Set)Preconditions.checkNotNull(dimensions, (String)"dimensions for %s", (Object[])new Object[]{alarmName});
        this.evaluationPeriods = evaluationPeriods;
        this.insufficientDataActions = (Set)Preconditions.checkNotNull(insufficientDataActions, (String)"insufficientDataActions for %s", (Object[])new Object[]{alarmName});
        this.metricName = (String)Preconditions.checkNotNull((Object)metricName, (String)"metricName for %s", (Object[])new Object[]{alarmName});
        this.namespace = (String)Preconditions.checkNotNull((Object)namespace, (String)"namespace for %s", (Object[])new Object[]{alarmName});
        this.okActions = (Set)Preconditions.checkNotNull(okActions, (String)"okActions for %s", (Object[])new Object[]{alarmName});
        this.period = period;
        this.stateReason = (String)Preconditions.checkNotNull((Object)stateReason, (String)"stateReason for %s", (Object[])new Object[]{alarmName});
        this.stateReasonData = (Optional)Preconditions.checkNotNull(stateReasonData, (String)"stateReasonData for %s", (Object[])new Object[]{alarmName});
        this.stateUpdatedTimestamp = (Date)Preconditions.checkNotNull((Object)stateUpdatedTimestamp, (String)"stateUpdatedTimestamp for %s", (Object[])new Object[]{alarmName});
        this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)state), (String)"state for %s", (Object[])new Object[]{alarmName}));
        Preconditions.checkArgument((state != State.UNRECOGNIZED ? 1 : 0) != 0, (Object)"state unrecognized");
        this.statistic = (Statistics)((Object)Preconditions.checkNotNull((Object)((Object)statistic), (String)"statistic for %s", (Object[])new Object[]{alarmName}));
        Preconditions.checkArgument((statistic != Statistics.UNRECOGNIZED ? 1 : 0) != 0, (Object)"statistic unrecognized");
        this.threshold = threshold;
        this.unit = (Optional)Preconditions.checkNotNull(unit, (String)"unit for %s", (Object[])new Object[]{alarmName});
        if (unit.isPresent()) {
            Preconditions.checkArgument((unit.get() != Unit.UNRECOGNIZED ? 1 : 0) != 0, (Object)"unit unrecognized");
        }
    }

    public boolean areActionsEnabled() {
        return this.areActionsEnabled;
    }

    public Set<String> getAlarmActions() {
        return this.alarmActions;
    }

    public String getAlarmARN() {
        return this.alarmARN;
    }

    public Date getAlarmConfigurationUpdatedTimestamp() {
        return this.alarmConfigurationUpdatedTimestamp;
    }

    public String getAlarmDescription() {
        return this.alarmDescription;
    }

    public String getAlarmName() {
        return this.alarmName;
    }

    public ComparisonOperator getComparisonOperator() {
        return this.comparisonOperator;
    }

    public Set<Dimension> getDimensions() {
        return this.dimensions;
    }

    public int getEvaluationPeriods() {
        return this.evaluationPeriods;
    }

    public Set<String> getInsufficientDataActions() {
        return this.insufficientDataActions;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Set<String> getOkActions() {
        return this.okActions;
    }

    public int getPeriod() {
        return this.period;
    }

    public String getStateReason() {
        return this.stateReason;
    }

    public Optional<String> getStateReasonData() {
        return this.stateReasonData;
    }

    public Date getStateUpdatedTimestamp() {
        return this.stateUpdatedTimestamp;
    }

    public State getState() {
        return this.state;
    }

    public Statistics getStatistic() {
        return this.statistic;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public Optional<Unit> getUnit() {
        return this.unit;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.alarmActions, this.alarmARN, this.alarmConfigurationUpdatedTimestamp, this.alarmDescription, this.alarmName, this.areActionsEnabled, this.comparisonOperator, this.dimensions, this.evaluationPeriods, this.insufficientDataActions, this.metricName, this.namespace, this.okActions, this.period, this.stateReason, this.stateReasonData, this.stateUpdatedTimestamp, this.state, this.statistic, this.threshold, this.unit});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Alarm other = (Alarm)obj;
        return Objects.equal(this.alarmActions, other.alarmActions) && Objects.equal((Object)this.alarmARN, (Object)other.alarmARN) && Objects.equal((Object)this.alarmConfigurationUpdatedTimestamp, (Object)other.alarmConfigurationUpdatedTimestamp) && Objects.equal((Object)this.alarmDescription, (Object)other.alarmDescription) && Objects.equal((Object)this.alarmName, (Object)other.alarmName) && Objects.equal((Object)this.areActionsEnabled, (Object)other.areActionsEnabled) && Objects.equal((Object)((Object)this.comparisonOperator), (Object)((Object)other.comparisonOperator)) && Objects.equal(this.dimensions, other.dimensions) && Objects.equal((Object)this.evaluationPeriods, (Object)other.evaluationPeriods) && Objects.equal(this.insufficientDataActions, other.insufficientDataActions) && Objects.equal((Object)this.metricName, (Object)other.metricName) && Objects.equal((Object)this.namespace, (Object)other.namespace) && Objects.equal(this.okActions, other.okActions) && Objects.equal((Object)this.period, (Object)other.period) && Objects.equal((Object)this.stateReason, (Object)other.stateReason) && Objects.equal(this.stateReasonData, other.stateReasonData) && Objects.equal((Object)this.stateUpdatedTimestamp, (Object)other.stateUpdatedTimestamp) && Objects.equal((Object)((Object)this.state), (Object)((Object)other.state)) && Objects.equal((Object)((Object)this.statistic), (Object)((Object)other.statistic)) && Objects.equal((Object)this.threshold, (Object)other.threshold) && Objects.equal(this.unit, other.unit);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("alarmActions", this.alarmActions).add("alarmARN", (Object)this.alarmARN).add("alarmConfigurationUpdateTimestamp", (Object)this.alarmConfigurationUpdatedTimestamp).add("alarmDescription", (Object)this.alarmDescription).add("alarmName", (Object)this.alarmName).add("areActionsEnabled", this.areActionsEnabled).add("comparisonOperator", (Object)this.comparisonOperator).add("dimensions", this.dimensions).add("evaluationPeriods", this.evaluationPeriods).add("insufficientDataActions", this.insufficientDataActions).add("metricName", (Object)this.metricName).add("namespace", (Object)this.namespace).add("okActions", this.okActions).add("period", this.period).add("stateReason", (Object)this.stateReason).add("stateReasonData", this.stateReasonData.orNull()).add("stateUpdatedTimestamp", (Object)this.stateUpdatedTimestamp).add("state", (Object)this.state).add("statistic", (Object)this.statistic).add("threshold", this.threshold).add("unit", this.unit.orNull()).toString();
    }

    public static enum State {
        ALARM,
        INSUFFICIENT_DATA,
        OK,
        UNRECOGNIZED;


        public static State fromValue(String value) {
            try {
                return State.valueOf((String)Preconditions.checkNotNull((Object)value, (Object)"value"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

