/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.geotools.util.DateRange;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;

public class DateTimeParser {
    static final Logger LOGGER = Logging.getLogger(DateTimeParser.class);
    private final Integer maxTimes;
    private final int flags;
    public static final int FLAG_GET_TIME_ON_PRESENT = 1;
    public static final int FLAG_GET_TIME_ON_NOW = 2;
    public static final int FLAG_GET_TIME_ON_CURRENT = 4;
    public static final int FLAG_IS_LENIENT = 256;
    public static final int FLAG_SINGLE_DATE_AS_DATERANGE = 65536;
    private static final Set<String> CURRENT_TIME_NAMES = new HashSet<String>(Arrays.asList("current", "now", "present"));
    private static final String SIMPLIFIED_FORMAT_MILLISECOND = "yyyyMMdd'T'HHmmssSSS";
    private static final String SIMPLIFIED_FORMAT_SECOND = "yyyyMMdd'T'HHmmss";
    private static final String SIMPLIFIED_FORMAT_MINUTE = "yyyyMMdd'T'HHmm";
    private static final String SIMPLIFIED_FORMAT_HOUR = "yyyyMMdd'T'HH";
    private static final String SIMPLIFIED_FORMAT_DAY = "yyyyMMdd";
    private static final String SIMPLIFIED_FORMAT_MONTH = "yyyyMM";
    private static final String SIMPLIFIED_FORMAT_YEAR = "yyyy";
    public static final String[] LENIENT_FORMATS_MILLISECOND = new String[]{"yyyyMMdd'T'HHmmssSSS'Z'", "yyyy-MM-dd'T'HHmmssSSS'Z'", "yyyy-MM-dd'T'HHmmssSSS", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyyMMdd'T'HH:mm:ss.SSS'Z'", "yyyyMMdd'T'HH:mm:ss.SSS", "yyyyMMdd'T'HHmmssSSS"};
    public static final String[] LENIENT_FORMATS_SECOND = new String[]{"yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HHmmss'Z'", "yyyyMMdd'T'HH:mm:ss'Z'", "yyyyMMdd'T'HHmmss'Z'", "yyyyMMdd'T'HH:mm:ss", "yyyy-MM-dd'T'HHmmss", "yyyyMMdd'T'HHmmss"};
    public static final String[] LENIENT_FORMATS_MINUTE = new String[]{"yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HHmm'Z'", "yyyyMMdd'T'HH:mm'Z'", "yyyyMMdd'T'HHmm'Z'", "yyyy-MM-dd'T'HHmm", "yyyyMMdd'T'HH:mm", "yyyyMMdd'T'HHmm"};
    public static final String[] LENIENT_FORMATS_HOUR = new String[]{"yyyyMMdd'T'HH'Z'", "yyyy-MM-dd'T'HH", "yyyyMMdd'T'HH"};
    public static final String[] LENIENT_FORMATS_DAY = new String[]{"yyyyMMdd"};
    public static final String[] LENIENT_FORMATS_MONTH = new String[]{"yyyyMM"};
    public static final String[] LENIENT_FORMATS_YEAR = new String[0];
    private static final String ISO8601_CHARS_REGEX = "([^(yyyy)|^(MM)|^(dd)|^(HH)|^(mm)|^(ss)|^(SSS)|^('T')])|('Z')";
    public static final TimeZone UTC_TZ = TimeZone.getTimeZone("UTC");
    public static final long MILLIS_IN_DAY = 86400000L;

    public DateTimeParser() {
        this(-1);
    }

    public DateTimeParser(int maxTimes) {
        this(maxTimes, 0);
    }

    public DateTimeParser(int maxTimes, int flags) {
        this.maxTimes = maxTimes;
        this.flags = flags;
    }

    private boolean isFlagSet(int referenceFlag) {
        return (this.flags & referenceFlag) == referenceFlag;
    }

    public Collection parse(String value) throws ParseException {
        if (value == null) {
            return Collections.emptyList();
        }
        if ((value = value.trim()).length() == 0) {
            return Collections.emptyList();
        }
        TreeSet result = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                boolean o1Date = o1 instanceof Date;
                boolean o2Date = o2 instanceof Date;
                if (o1 == o2) {
                    return 0;
                }
                if (o1Date) {
                    Date dateLeft = (Date)o1;
                    if (o2Date) {
                        return dateLeft.compareTo((Date)o2);
                    }
                    return dateLeft.compareTo(((DateRange)o2).getMinValue());
                }
                DateRange left = (DateRange)o1;
                if (o2Date) {
                    return left.getMinValue().compareTo((Date)o2);
                }
                return left.getMinValue().compareTo(((DateRange)o2).getMinValue());
            }
        });
        String[] listDates = value.split(",");
        int maxValues = this.maxTimes;
        for (String date : listDates) {
            if (date.indexOf("/") <= 0) {
                Object o = this.getFuzzyDate(date);
                if (o instanceof Date) {
                    DateTimeParser.addDate(result, (Date)o);
                } else {
                    DateTimeParser.addPeriod(result, (DateRange)o);
                }
            } else {
                Date[] range;
                Object[] period = date.split("/");
                if (period.length == 3) {
                    long time;
                    range = this.parseTimeDuration((String[])period);
                    long millisIncrement = DateTimeParser.parsePeriod(period[2]);
                    long startTime = range[0].getTime();
                    long endTime = range[1].getTime();
                    int j = 0;
                    while ((time = (long)j * millisIncrement + startTime) <= endTime) {
                        GregorianCalendar calendar = new GregorianCalendar(UTC_TZ);
                        calendar.setTimeInMillis(time);
                        DateTimeParser.addDate(result, calendar.getTime());
                        ++j;
                        this.checkMaxTimes(result, maxValues);
                    }
                } else if (period.length == 2) {
                    range = this.parseTimeDuration((String[])period);
                    DateTimeParser.addPeriod(result, new DateRange(range[0], range[1]));
                } else {
                    throw new ParseException("Invalid time period: " + Arrays.toString(period), 0);
                }
            }
            this.checkMaxTimes(result, maxValues);
        }
        return new ArrayList(result);
    }

    public void checkMaxTimes(Set result, int maxValues) {
        if (maxValues > 0 && result.size() > maxValues) {
            throw new RuntimeException("More than " + maxValues + " times specified in the request, bailing out.");
        }
    }

    private Date[] parseTimeDuration(String[] period) throws ParseException {
        Date[] range = null;
        if (period.length == 2 || period.length == 3) {
            Date begin = null;
            Date end = null;
            if (period[0].toUpperCase().startsWith("P") || period[1].toUpperCase().startsWith("P")) {
                long durationOffset = Long.MIN_VALUE;
                if (period[0].toUpperCase().startsWith("P")) {
                    durationOffset = DateTimeParser.parsePeriod(period[0]);
                } else {
                    begin = DateTimeParser.beginning(this.getFuzzyDate(period[0]));
                }
                if (period[1].toUpperCase().startsWith("P") && !period[1].toUpperCase().startsWith("PRESENT")) {
                    if (durationOffset != Long.MIN_VALUE) {
                        throw new ParseException("Invalid time period containing duration with no paired time value: " + Arrays.toString(period), 0);
                    }
                    durationOffset = DateTimeParser.parsePeriod(period[1]);
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTimeInMillis(begin.getTime() + durationOffset);
                    end = calendar.getTime();
                } else {
                    end = DateTimeParser.end(this.getFuzzyDate(period[1]));
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTimeInMillis(end.getTime() - durationOffset);
                    begin = calendar.getTime();
                }
            } else {
                begin = DateTimeParser.beginning(this.getFuzzyDate(period[0]));
                end = DateTimeParser.end(this.getFuzzyDate(period[1]));
            }
            range = new Date[]{begin, end};
        }
        return range;
    }

    private static Date beginning(Object dateOrDateRange) {
        if (dateOrDateRange instanceof DateRange) {
            return ((DateRange)dateOrDateRange).getMinValue();
        }
        return (Date)dateOrDateRange;
    }

    private static Date end(Object dateOrDateRange) {
        if (dateOrDateRange instanceof DateRange) {
            return ((DateRange)dateOrDateRange).getMaxValue();
        }
        return (Date)dateOrDateRange;
    }

    private static void addPeriod(Collection result, DateRange newRange) {
        Iterator it = result.iterator();
        while (it.hasNext()) {
            Serializable local;
            Object element = it.next();
            if (element instanceof Date) {
                local = (Date)element;
                if (!newRange.contains((Comparable<?>)((Object)local))) continue;
                it.remove();
                continue;
            }
            local = (DateRange)element;
            if (((Range)local).contains(newRange)) {
                return;
            }
            if (!newRange.contains((Range<?>)local)) continue;
            it.remove();
        }
        result.add(newRange);
    }

    private static void addDate(Collection result, Date newDate) {
        for (Object element : result) {
            if (!(element instanceof Date ? newDate.equals(element) : ((DateRange)element).contains(newDate))) continue;
            return;
        }
        result.add(newDate);
    }

    private Object getFuzzyDate(String value) throws ParseException {
        String computedValue = value;
        if (CURRENT_TIME_NAMES.contains(computedValue.toLowerCase())) {
            if (computedValue.equalsIgnoreCase("current") && this.isFlagSet(4) || computedValue.equalsIgnoreCase("now") && this.isFlagSet(2) || computedValue.equalsIgnoreCase("present") && this.isFlagSet(1)) {
                Calendar now = Calendar.getInstance();
                now.set(14, 0);
                computedValue = FormatAndPrecision.MILLISECOND.getFormat().format(now.getTime());
            } else {
                return null;
            }
        }
        for (FormatAndPrecision f : FormatAndPrecision.values()) {
            Object parsedTime = this.parseTime(f, computedValue);
            if (parsedTime == null) continue;
            return parsedTime;
        }
        throw new ParseException("Invalid date: " + value, 0);
    }

    public static long parsePeriod(String period) throws ParseException {
        int length = period.length();
        if (length != 0 && Character.toUpperCase(period.charAt(0)) != 'P') {
            throw new ParseException("Invalid period increment given: " + period, 0);
        }
        long millis = 0L;
        boolean time = false;
        int lower = 0;
        while (++lower < length) {
            double factor;
            double value;
            int upper;
            block17: {
                char letter;
                block16: {
                    letter = Character.toUpperCase(period.charAt(lower));
                    if (letter == 'T') {
                        time = true;
                        if (++lower >= length) break;
                    }
                    upper = lower;
                    letter = period.charAt(upper);
                    while (!Character.isLetter(letter) || letter == 'e' || letter == 'E') {
                        if (++upper >= length) {
                            throw new ParseException("Missing symbol in \"" + period + "\".", lower);
                        }
                        letter = period.charAt(upper);
                    }
                    letter = Character.toUpperCase(letter);
                    value = Double.parseDouble(period.substring(lower, upper));
                    if (!time) break block16;
                    switch (letter) {
                        case 'S': {
                            factor = 1000.0;
                            break block17;
                        }
                        case 'M': {
                            factor = 60000.0;
                            break block17;
                        }
                        case 'H': {
                            factor = 3600000.0;
                            break block17;
                        }
                        default: {
                            throw new ParseException("Unknown time symbol: " + letter, upper);
                        }
                    }
                }
                switch (letter) {
                    case 'D': {
                        factor = 8.64E7;
                        break;
                    }
                    case 'W': {
                        factor = 6.048E8;
                        break;
                    }
                    case 'M': {
                        factor = 2.592E9;
                        break;
                    }
                    case 'Y': {
                        factor = 3.15576E10;
                        break;
                    }
                    default: {
                        throw new ParseException("Unknown period symbol: " + letter, upper);
                    }
                }
            }
            millis += Math.round(value * factor);
            lower = upper;
        }
        return millis;
    }

    private Object parseTime(FormatAndPrecision f, String value) {
        ParsePosition pos = new ParsePosition(0);
        Date time = f.getFormat().parse(value, pos);
        Object parsed = this.parseAsDateRangeWithFormatPrecision(time, value, pos, f);
        if (parsed == null && this.isFlagSet(256)) {
            for (String lenientFormat : f.getLenientFormats()) {
                SimpleDateFormat format = new SimpleDateFormat(lenientFormat);
                format.setTimeZone(UTC_TZ);
                format.setLenient(false);
                time = format.parse(value, pos);
                parsed = this.parseAsDateRangeWithFormatPrecision(time, value, pos, f);
                if (parsed == null) continue;
                return parsed;
            }
        }
        return parsed;
    }

    private Object parseAsDateRangeWithFormatPrecision(Date time, String computedValue, ParsePosition pos, FormatAndPrecision f) {
        if (time != null && pos != null && pos.getIndex() == computedValue.length()) {
            DateRange range = f.expand(time);
            if (range.getMinValue().equals(range.getMaxValue()) || !this.isFlagSet(65536)) {
                return range.getMinValue();
            }
            return range;
        }
        return null;
    }

    public static enum FormatAndPrecision {
        MILLISECOND("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", 14, LENIENT_FORMATS_MILLISECOND),
        SECOND("yyyy-MM-dd'T'HH:mm:ss'Z'", 13, LENIENT_FORMATS_SECOND),
        MINUTE("yyyy-MM-dd'T'HH:mm'Z'", 12, LENIENT_FORMATS_MINUTE),
        HOUR("yyyy-MM-dd'T'HH'Z'", 11, LENIENT_FORMATS_HOUR),
        DAY("yyyy-MM-dd", 5, LENIENT_FORMATS_DAY),
        MONTH("yyyy-MM", 2, LENIENT_FORMATS_MONTH),
        YEAR("yyyy", 1, LENIENT_FORMATS_YEAR);

        public final String format;
        public final int precision;
        public final String[] lenientFormats;

        private FormatAndPrecision(String format, int precision, String[] lenientFormats) {
            this.format = format;
            this.precision = precision;
            this.lenientFormats = lenientFormats;
        }

        public SimpleDateFormat getFormat() {
            SimpleDateFormat sdf = new SimpleDateFormat(this.format);
            sdf.setTimeZone(UTC_TZ);
            return sdf;
        }

        public String[] getLenientFormats() {
            return this.lenientFormats;
        }

        public DateRange expand(Date d) {
            return FormatAndPrecision.expandToPrecision(d, this.precision);
        }

        public static DateRange expandFromCustomFormat(Date d, String format) {
            int precision = FormatAndPrecision.findPrecision(format);
            return FormatAndPrecision.expandToPrecision(d, precision);
        }

        private static DateRange expandToPrecision(Date d, int precision) {
            GregorianCalendar c = new GregorianCalendar(UTC_TZ);
            c.setTime(d);
            ((Calendar)c).add(precision, 1);
            ((Calendar)c).add(14, -1);
            return new DateRange(d, c.getTime());
        }

        private static int findPrecision(String format) {
            String simplifiedFormat = format.replaceAll(DateTimeParser.ISO8601_CHARS_REGEX, "");
            if (DateTimeParser.SIMPLIFIED_FORMAT_MILLISECOND.equalsIgnoreCase(simplifiedFormat)) {
                return 14;
            }
            if (DateTimeParser.SIMPLIFIED_FORMAT_SECOND.equalsIgnoreCase(simplifiedFormat)) {
                return 13;
            }
            if (DateTimeParser.SIMPLIFIED_FORMAT_MINUTE.equalsIgnoreCase(simplifiedFormat)) {
                return 12;
            }
            if (DateTimeParser.SIMPLIFIED_FORMAT_HOUR.equalsIgnoreCase(simplifiedFormat)) {
                return 10;
            }
            if (DateTimeParser.SIMPLIFIED_FORMAT_DAY.equalsIgnoreCase(simplifiedFormat)) {
                return 5;
            }
            if (DateTimeParser.SIMPLIFIED_FORMAT_MONTH.equalsIgnoreCase(simplifiedFormat)) {
                return 2;
            }
            if (DateTimeParser.SIMPLIFIED_FORMAT_YEAR.equalsIgnoreCase(simplifiedFormat)) {
                return 1;
            }
            if (simplifiedFormat.endsWith("SSS")) {
                return 14;
            }
            if (simplifiedFormat.endsWith("ss")) {
                return 13;
            }
            if (simplifiedFormat.endsWith("mm")) {
                return 12;
            }
            if (simplifiedFormat.endsWith("HH")) {
                return 10;
            }
            if (simplifiedFormat.endsWith("dd")) {
                return 5;
            }
            if (simplifiedFormat.endsWith("mm")) {
                return 2;
            }
            if (simplifiedFormat.endsWith(DateTimeParser.SIMPLIFIED_FORMAT_YEAR)) {
                return 1;
            }
            throw new IllegalArgumentException("Unable to identify an ISO8601 format corresponding to the provided format:" + format);
        }
    }
}

