/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.LoadBalancerApi;
import org.jclouds.util.Predicates2;

public class LoadBalancerPredicates {
    public static Predicate<LoadBalancer> awaitAvailable(LoadBalancerApi loadBalancerApi) {
        StatusUpdatedPredicate statusPredicate = new StatusUpdatedPredicate(loadBalancerApi, LoadBalancer.Status.ACTIVE);
        return Predicates2.retry((Predicate)statusPredicate, (long)300L, (long)3L, (long)3L, (TimeUnit)TimeUnit.SECONDS);
    }

    public static Predicate<LoadBalancer> awaitDeleted(LoadBalancerApi loadBalancerApi) {
        DeletedPredicate deletedPredicate = new DeletedPredicate(loadBalancerApi);
        return Predicates2.retry((Predicate)deletedPredicate, (long)300L, (long)3L, (long)3L, (TimeUnit)TimeUnit.SECONDS);
    }

    public static Predicate<LoadBalancer> awaitStatus(LoadBalancerApi loadBalancerApi, LoadBalancer.Status status, long maxWaitInSec, long periodInSec) {
        StatusUpdatedPredicate statusPredicate = new StatusUpdatedPredicate(loadBalancerApi, status);
        return Predicates2.retry((Predicate)statusPredicate, (long)maxWaitInSec, (long)periodInSec, (long)periodInSec, (TimeUnit)TimeUnit.SECONDS);
    }

    private static class DeletedPredicate
    implements Predicate<LoadBalancer> {
        private LoadBalancerApi loadBalancerApi;

        public DeletedPredicate(LoadBalancerApi loadBalancerApi) {
            this.loadBalancerApi = (LoadBalancerApi)Preconditions.checkNotNull((Object)loadBalancerApi, (Object)"loadBalancerApi must be defined");
        }

        public boolean apply(LoadBalancer loadBalancer) {
            Preconditions.checkNotNull((Object)loadBalancer, (Object)"loadBalancer must be defined");
            LoadBalancer loadBalancerUpdate = this.loadBalancerApi.get(loadBalancer.getId());
            if (loadBalancerUpdate == null) {
                return true;
            }
            return loadBalancerUpdate.getStatus().equals((Object)LoadBalancer.Status.DELETED);
        }
    }

    private static class StatusUpdatedPredicate
    implements Predicate<LoadBalancer> {
        private LoadBalancerApi loadBalancerApi;
        private LoadBalancer.Status status;

        public StatusUpdatedPredicate(LoadBalancerApi loadBalancerApi, LoadBalancer.Status status) {
            this.loadBalancerApi = (LoadBalancerApi)Preconditions.checkNotNull((Object)loadBalancerApi, (Object)"loadBalancerApi must be defined");
            this.status = (LoadBalancer.Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status must be defined"));
        }

        public boolean apply(LoadBalancer loadBalancer) {
            Preconditions.checkNotNull((Object)loadBalancer, (Object)"loadBalancer must be defined");
            LoadBalancer loadBalancerUpdated = this.loadBalancerApi.get(loadBalancer.getId());
            Preconditions.checkNotNull((Object)loadBalancerUpdated, (String)"LoadBalancer %s not found.", (Object[])new Object[]{loadBalancer.getId()});
            return this.status.equals((Object)loadBalancerUpdated.getStatus());
        }
    }
}

