/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.BooleanCollection;
import bak.pcj.hash.DefaultBooleanHashFunction;
import bak.pcj.hash.DefaultLongHashFunction;
import bak.pcj.map.LongKeyBooleanMap;
import bak.pcj.map.LongKeyBooleanMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.LongSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractLongKeyBooleanMap
implements LongKeyBooleanMap {
    protected AbstractLongKeyBooleanMap() {
    }

    public void clear() {
        LongKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public boolean remove(long key) {
        LongKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            boolean value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultBoolean();
    }

    public void putAll(LongKeyBooleanMap map) {
        LongKeyBooleanMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(long key) {
        LongKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public boolean get(long key) {
        LongKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultBoolean();
    }

    public boolean containsValue(boolean value) {
        LongKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LongKeyBooleanMap)) {
            return false;
        }
        LongKeyBooleanMap map = (LongKeyBooleanMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        LongKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            long k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        LongKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultLongHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultBooleanHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        LongKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public boolean tget(long key) {
        boolean value = this.get(key);
        if (value == MapDefaults.defaultBoolean() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        LongKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract BooleanCollection values();

    public abstract boolean put(long var1, boolean var3);

    public abstract boolean lget();

    public abstract LongSet keySet();

    public abstract LongKeyBooleanMapIterator entries();
}

