/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JWindow;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.dlib.gui.GuiUtil;
import org.dlib.gui.TLabel;

public class MessageWindow
extends JWindow {
    private Component parent;
    private TLabel label = new TLabel();
    private static final Font font = new Font("default", 1, 30);

    public MessageWindow() {
        this((Component)null);
    }

    public MessageWindow(Component component) {
        this.parent = component;
        Border border = BorderFactory.createRaisedBevelBorder();
        Border border2 = BorderFactory.createEmptyBorder(6, 40, 6, 40);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, border2);
        this.label.setBorder(compoundBorder);
        this.label.setFont(font);
        this.label.setForeground(Color.DARK_GRAY);
        this.getContentPane().add((Component)this.label, "Center");
        this.update(this.getGraphics());
    }

    public void showMessage(String string) {
        Serializable serializable;
        Dimension dimension;
        this.label.setText(string);
        this.pack();
        Point point = new Point();
        if (this.parent == null) {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
        } else {
            serializable = GuiUtil.getFrame(this.parent);
            point = ((Component)serializable).getLocationOnScreen();
            dimension = ((Component)serializable).getSize();
        }
        serializable = this.label.getPreferredSize();
        this.setLocation(point.x + dimension.width / 2 - ((Dimension)serializable).width / 2, point.y + dimension.height / 2 - ((Dimension)serializable).height / 2);
        this.setVisible(true);
    }
}

