/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.users.transfer;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.repository.specification.UserSpecs;
import org.jdom.Element;
import org.springframework.data.jpa.domain.Specification;

public class OwnershipUtils {
    public static List<Element> getOwnerUsers(ServiceContext context, UserSession us) throws SQLException {
        if (!us.isAuthenticated()) {
            return new ArrayList<Element>();
        }
        List allUsersThatOwnMetadata = ((UserRepository)context.getBean(UserRepository.class)).findAllUsersThatOwnMetadata();
        return OwnershipUtils.getUsers(context, us, allUsersThatOwnMetadata);
    }

    public static List<Element> getEditorUsers(ServiceContext context, UserSession us) throws SQLException {
        if (!us.isAuthenticated()) {
            return new ArrayList<Element>();
        }
        List users = ((UserRepository)context.getBean(UserRepository.class)).findAll(Specification.not((Specification)UserSpecs.hasProfile((Profile)Profile.RegisteredUser)));
        return OwnershipUtils.getUsers(context, us, users);
    }

    @Deprecated
    public static List<Element> getUsers(ServiceContext context, UserSession us, List<User> users) throws SQLException {
        int id = us.getUserIdAsInt();
        if (us.getProfile() == Profile.Administrator) {
            List userXml = Lists.transform(users, (Function)new Function<User, Element>(){

                @Nonnull
                public Element apply(@Nonnull User input) {
                    return input.asXml();
                }
            });
            return userXml;
        }
        Set<String> hsMyGroups = OwnershipUtils.getUserGroups(context, id);
        Set profileSet = us.getProfile().getAll();
        ArrayList<Element> newList = new ArrayList<Element>();
        for (User elRec : users) {
            int userId = elRec.getId();
            Profile profile = elRec.getProfile();
            if (!profileSet.contains(profile) || !hsMyGroups.containsAll(OwnershipUtils.getUserGroups(context, userId))) continue;
            newList.add(elRec.asXml());
        }
        return newList;
    }

    protected static Set<String> getUserGroups(ServiceContext context, int id) throws SQLException {
        HashSet<String> groupIds = new HashSet<String>();
        List users = ((UserGroupRepository)context.getBean(UserGroupRepository.class)).findAll(UserGroupSpecs.hasUserId((int)id));
        for (UserGroup el : users) {
            groupIds.add("" + el.getId().getGroupId());
        }
        return groupIds;
    }
}

