/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.attachments;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.nio.file.Path;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.thumbnail.ThumbnailMaker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@EnableWebMvc
@Controller
@Service
@Tag(name="records", description="Metadata record operations")
public class AttachmentsActionsApi {
    private final ApplicationContext appContext = ApplicationContextHolder.get();
    @Autowired
    DataManager dataMan;
    @Autowired
    ThumbnailMaker thumbnailMaker;
    private Store store;

    public AttachmentsActionsApi() {
    }

    public AttachmentsActionsApi(Store store) {
        this.store = store;
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    @PostConstruct
    public void init() {
        if (this.appContext != null) {
            this.store = (Store)this.appContext.getBean("resourceStore", Store.class);
        }
    }

    @Operation(summary="Create an overview using the map print module", description="<a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/associating-resources/linking-thumbnail.html#generating-a-thumbnail-using-wms-layers'>More info</a>")
    @RequestMapping(value={"/{portal}/api/records/{metadataUuid}/attachments/print-thumbnail"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Thumbnail created."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public MetadataResource saveThumbnail(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="The mapprint module JSON configuration", required=true) @RequestParam String jsonConfig, @Parameter(description="The rotation angle of the map") @RequestParam(required=false, defaultValue="0") int rotationAngle, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        ApiUtils.canEditRecord(metadataUuid, request);
        Path thumbnailFile = this.thumbnailMaker.generateThumbnail(jsonConfig, Integer.valueOf(rotationAngle));
        return this.store.putResource(context, metadataUuid, thumbnailFile, MetadataResourceVisibility.PUBLIC, Boolean.valueOf(false));
    }
}

