/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.site;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataDataInfo_;
import org.fao.geonet.domain.Metadata_;
import org.fao.geonet.domain.OperationAllowedId_;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.exceptions.SitemapDocumentNotFoundEx;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api"})
@Tag(name="site", description="Catalog operations")
@Controller(value="sitemap")
public class SitemapApi {
    private static final String FORMAT_XML = "xml";
    private static final String FORMAT_HTML = "html";
    private static final int MAX_ITEMS_PER_PAGE = 2500;
    @Autowired
    SettingManager settingManager;
    @Autowired
    NodeInfo node;
    @Autowired
    OperationAllowedRepository operationAllowedRepository;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    GeonetworkDataDirectory dataDirectory;

    @Operation(summary="robots.txt", description="")
    @RequestMapping(path={"/robots.txt"}, produces={"text/plain"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="robots.txt file for SEO.")})
    @ResponseBody
    public String getRobotsText() throws Exception {
        StringBuffer response = new StringBuffer();
        response.append("sitemap: ").append(this.settingManager.getNodeURL()).append("api/sitemap").append("\n");
        response.append("sitemap: ").append(this.settingManager.getNodeURL()).append("api/sitemap?format=rdf");
        return response.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Operation(summary="Get sitemap", description="")
    @RequestMapping(path={"/sitemap"}, produces={"application/xml"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Site map.")})
    @ResponseBody
    public ResponseEntity<Element> getSitemap(@Parameter(description="Format (xml or html).", required=false) @RequestParam(required=false, defaultValue="html") String format, @Parameter(description="page.", required=false) @RequestParam(required=false, defaultValue="0") Integer doc, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        if (!format.equalsIgnoreCase(FORMAT_HTML) && !format.equalsIgnoreCase(FORMAT_XML)) {
            format = FORMAT_HTML;
        }
        Integer allgroup = 1;
        Specification spec = Specification.where((Specification)OperationAllowedSpecs.hasOperation((ReservedOperation)ReservedOperation.view));
        spec = spec.and(OperationAllowedSpecs.hasGroupId((int)allgroup));
        List list = this.operationAllowedRepository.findAllIds(spec, OperationAllowedId_.metadataId);
        Sort sortByChangeDateDesc = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{Metadata_.dataInfo.getName() + "." + MetadataDataInfo_.changeDate.getName()});
        long metadatataCount = this.metadataRepository.count(MetadataSpecs.hasMetadataIdIn((Collection)list));
        long pages = (long)Math.ceil((double)metadatataCount / 2500.0);
        Element result = null;
        if (doc > 0) {
            if ((long)doc.intValue() > pages) throw new SitemapDocumentNotFoundEx(doc.intValue());
            PageRequest pageRequest = PageRequest.of((int)(doc - 1), (int)2500, (Sort)sortByChangeDateDesc);
            result = this.metadataRepository.findUuidsAndChangeDatesAndSchemaId(list, (Pageable)pageRequest);
            Element formatEl = new Element("format");
            formatEl.setText(format.toLowerCase());
            result.addContent((Content)formatEl);
        } else if (metadatataCount <= 2500L) {
            result = this.metadataRepository.findUuidsAndChangeDatesAndSchemaId(list);
            Element formatEl = new Element("format");
            formatEl.setText(format.toLowerCase());
            result.addContent((Content)formatEl);
        } else {
            result = new Element("response");
            Element indexDocs = new Element("indexDocs");
            indexDocs.setText(pages + "");
            result.addContent((Content)indexDocs);
            Element changeDate = new Element("changeDate");
            changeDate.setText(new ISODate().toString());
            result.addContent((Content)changeDate);
        }
        Path xslt = this.dataDirectory.getWebappDir().resolve("xslt/services/sitemap/sitemap.xsl");
        Element root = new Element("root");
        Element requestElt = new Element("request");
        requestElt.addContent((Content)new Element("format").setText(format));
        root.addContent((Content)requestElt);
        root.addContent((Content)result);
        Element sitemap = Xml.transform((Element)root, (Path)xslt);
        return new ResponseEntity((Object)sitemap, HttpStatus.OK);
    }
}

