/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.records.formatters.FormatterImpl;
import org.fao.geonet.api.records.formatters.FormatterParams;
import org.fao.geonet.api.records.formatters.SchemaLocalization;
import org.fao.geonet.api.records.formatters.SchemaLocalizations;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class XsltFormatter
implements FormatterImpl {
    public static List<Element> getSchemaLocalization(String schema, List<String> schemasToLoadList, String language) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        Collection<SchemaLocalization> localization = SchemaLocalizations.loadSchemaLocalizations((ApplicationContext)applicationContext, (SchemaManager)applicationContext.getBean(SchemaManager.class)).values();
        ArrayList<Element> elementList = new ArrayList<Element>(3);
        for (SchemaLocalization schemaLocalization : localization) {
            String currentSchema = schemaLocalization.schema.trim();
            if (!"all".equalsIgnoreCase(schema)) {
                if (!schemasToLoadList.stream().anyMatch(currentSchema::equalsIgnoreCase)) continue;
            }
            Element schemaEl = new Element(currentSchema);
            Element labels = schemaLocalization.getLabels(language);
            schemaEl.addContent((Content)((Element)labels.setName("labels").clone()));
            Element strings = schemaLocalization.getStrings(language);
            schemaEl.addContent((Content)((Element)strings.setName("strings").clone()));
            Element codelists = schemaLocalization.getCodelists(language);
            schemaEl.addContent((Content)((Element)codelists.setName("codelists").clone()));
            elementList.add(schemaEl);
        }
        return elementList;
    }

    public static List<Element> getSchemaLocalization(String schema, String language) throws Exception {
        ArrayList<String> schemaToLoad = new ArrayList<String>();
        schemaToLoad.add(schema);
        return XsltFormatter.getSchemaLocalization(null, schemaToLoad, language);
    }

    @Override
    public String format(FormatterParams fparams) throws Exception {
        Element transformed;
        String lang = fparams.config.getLang(fparams.context.getLanguage());
        Element root = new Element("root");
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        root.addContent((Content)new Element("lang").setText(fparams.context.getLanguage()));
        root.addContent((Content)new Element("url").setText(fparams.url));
        Element translations = new Element("translations");
        Element gui = new Element("gui");
        String baseUrl = settingManager.getBaseURL();
        String context = baseUrl.replace(settingManager.getServerURL(), "");
        gui.addContent((Content)new Element("url").setText(context.substring(0, context.length() - 1)));
        gui.addContent((Content)new Element("nodeUrl").setText(settingManager.getNodeURL()));
        gui.addContent((Content)new Element("baseUrl").setText(baseUrl));
        gui.addContent((Content)new Element("serverUrl").setText(settingManager.getServerURL()));
        gui.addContent((Content)new Element("language").setText(fparams.context.getLanguage()));
        gui.addContent((Content)new Element("reqService").setText("md.format.html"));
        Element env = new Element("systemConfig");
        env.addContent((Content)settingManager.getAllAsXML(true));
        gui.addContent((Content)env);
        root.addContent((Content)gui);
        root.addContent((Content)new Element("locUrl").setText(fparams.getLocUrl()));
        root.addContent((Content)new Element("resourceUrl").setText(fparams.getResourceUrl()));
        root.addContent((Content)fparams.metadata);
        Element info = fparams.metadataInfo.asXml();
        info.removeChild("data");
        root.addContent((Content)new Element("info").addContent((Content)info));
        root.addContent((Content)fparams.format.getPluginLocResources(fparams.context, fparams.formatDir, lang));
        if (fparams.config.loadStrings()) {
            root.addContent((Content)fparams.format.getStrings(fparams.context.getAppPath(), lang));
        }
        Element schemas = new Element("schemas");
        root.addContent((Content)schemas);
        List<String> schemasToLoadList = fparams.config.listOfSchemasToLoad();
        String schemasToLoad = fparams.config.schemasToLoad();
        if (!"none".equalsIgnoreCase(schemasToLoad)) {
            List<Element> elementList = XsltFormatter.getSchemaLocalization(schemasToLoad, schemasToLoadList, fparams.context.getLanguage());
            for (Element e : elementList) {
                schemas.addContent((Content)e);
            }
        }
        HashMap requestParameters = new HashMap();
        if (fparams.webRequest != null) {
            for (String key : fparams.webRequest.getParameterMap().keySet()) {
                requestParameters.put(key, fparams.webRequest.getParameterMap().get(key));
            }
        }
        return "textResponse".equals((transformed = Xml.transform((Element)root, (Path)fparams.viewFile, requestParameters)).getName()) ? transformed.getText() : Xml.getString((Element)transformed);
    }
}

