/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.exceptions.BadServerResponseEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.harvest.HarvestManager;
import org.fao.geonet.kernel.harvest.harvester.AbstractHarvester;
import org.fao.geonet.kernel.harvest.harvester.geonet.GeonetParams;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@Controller(value="recordSocial")
@ReadWriteController
public class MetadataSocialApi {
    @Autowired
    LanguageUtils languageUtils;

    @Operation(summary="Rate a record", description="User rating of metadata. If the metadata was harvested using the 'GeoNetwork' protocol and the system setting localrating/enable is false (the default), the user's rating is shared between GN nodes in this harvesting network. If the metadata was not harvested or if localrating/enable is true then 'local rating' is applied, counting only rating from users of this node.<br/>When a remote rating is applied, the local rating is not updated. It will be updated on the next harvest run (FIXME ?).")
    @RequestMapping(value={"/{metadataUuid}/rate"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="New rating value."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public Integer rateRecord(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Rating", required=true) @RequestBody(required=true) Integer rating, HttpServletRequest request) throws Exception {
        AbstractHarvester ah;
        AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        ServiceContext context = ApiUtils.createServiceContext(request);
        String ip = context.getIpAddress();
        if (ip == null) {
            ip = "???.???.???.???";
        }
        if (rating < 0 || rating > 5) {
            throw new BadParameterEx(String.format("Parameter rating MUST be between 1 and 5. Value %s is invalid.", new Object[0]), (Object)rating);
        }
        String harvUuid = metadata.getHarvestInfo().getUuid();
        DataManager dataManager = (DataManager)appContext.getBean(DataManager.class);
        HarvestManager hm = (HarvestManager)appContext.getBean(HarvestManager.class);
        SettingManager settingManager = (SettingManager)appContext.getBean(SettingManager.class);
        String localRating = settingManager.getValue("system/localrating/enable");
        rating = localRating.equals("basic") || harvUuid == null ? Integer.valueOf(dataManager.rateMetadata(metadata.getId(), ip, rating.intValue())) : ((ah = hm.getHarvester(harvUuid)).getType().equals("geonetwork") ? Integer.valueOf(this.setRemoteRating(context, (GeonetParams)ah.getParams(), metadataUuid, rating)) : Integer.valueOf(-1));
        return rating;
    }

    private int setRemoteRating(ServiceContext context, GeonetParams params, String uuid, int rating) throws Exception {
        if (context.isDebugEnabled()) {
            context.debug("Rating remote metadata with uuid:" + uuid);
        }
        XmlRequest req = ((GeonetHttpRequestFactory)context.getBean(GeonetHttpRequestFactory.class)).createXmlRequest(new URL(params.host));
        Lib.net.setupProxy(context, req);
        req.setAddress(params.getServletPath() + "/srv/eng/" + "xml.metadata.rate");
        req.clearParams();
        req.addParam("uuid", (Object)uuid);
        req.addParam("rating", (Object)rating);
        Element response = req.execute();
        if (!response.getName().equals("rating")) {
            throw new BadServerResponseEx((Object)response);
        }
        return Integer.parseInt(response.getText());
    }
}

