/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.processing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.processing.XslProcessUtils;
import org.fao.geonet.api.processing.report.XsltMetadataProcessingReport;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.events.history.RecordProcessingChangeEvent;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.MetadataIndexerProcessor;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.utils.Diff;
import org.fao.geonet.utils.DiffType;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/processes"})
@Tag(name="processes", description="Processing operations")
@Controller(value="xslprocess")
@ReadWriteController
public class XslProcessApi {
    @Autowired
    DataManager dataMan;
    @Autowired
    SchemaManager schemaMan;
    @Autowired
    SettingManager settingManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Preview process result applied to one or more records", description="Preview result of a process applied to metadata records with an XSL transformation declared in the metadata schema (See the process folder). Parameters sent to the service are forwarded to XSL process. Append mode has 2 limitations. First, it only support a set of records in the same schema. Secondly, it does not propagate URL parameters. This mode is mainly used to create custom reports based on metadata records content.If process name ends with '.csv', the XSL process output a text document which is returned. When errors occur during processing, the processing report is returned in JSON format.")
    @RequestMapping(value={"/{process:.+}"}, method={RequestMethod.GET}, consumes={"text/html", "*/*"}, produces={"*/*"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Processed records."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    public Object previewProcessRecords(@Parameter(description="Process identifier") @PathVariable String process, @Parameter(description="Return differences with diff, diffhtml or patch", required=false) @RequestParam(required=false) DiffType diffType, @Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="Append documents before processing", required=false, example="false") @RequestParam(required=false, defaultValue="false") boolean appendFirst, @Parameter(hidden=true) HttpSession httpSession, @Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpServletResponse response) throws IllegalArgumentException {
        UserSession session = ApiUtils.getUserSession(httpSession);
        XsltMetadataProcessingReport xslProcessingReport = new XsltMetadataProcessingReport(process);
        Element preview = new Element("preview");
        StringBuffer output = new StringBuffer();
        boolean isText = process.endsWith(".csv");
        response.setHeader("Content-Type", isText ? "text/plain" : "application/xml");
        try {
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
            String siteURL = request.getRequestURL().toString() + "?" + request.getQueryString();
            Element mergedDocuments = new Element("records");
            String schema = null;
            for (String uuid : records) {
                String id = this.dataMan.getMetadataId(uuid);
                Log.info((String)"org.fao.geonet.services.metadata", (Object)("Processing metadata for preview with id:" + id));
                if (appendFirst) {
                    String currentSchema = this.dataMan.getMetadataSchema(id);
                    if (schema != null && !currentSchema.equals(schema)) {
                        throw new IllegalArgumentException(String.format("When using append mode, process preview cannot process records with different schemas. Record with uuid '%s' as schema '%s'. Select only records in the same schema (ie. '%s')", uuid, currentSchema, schema));
                    }
                    schema = currentSchema;
                    mergedDocuments.addContent((Content)this.dataMan.getMetadata(id));
                    continue;
                }
                ServiceContext serviceContext = ApiUtils.createServiceContext(request);
                if (isText) {
                    output.append(XslProcessUtils.processAsText(serviceContext, id, process, false, xslProcessingReport, siteURL, request.getParameterMap()));
                    continue;
                }
                Element record = XslProcessUtils.process(serviceContext, id, process, false, false, false, xslProcessingReport, siteURL, request.getParameterMap());
                if (record == null) continue;
                if (diffType != null) {
                    IMetadataUtils metadataUtils = (IMetadataUtils)serviceContext.getBean(IMetadataUtils.class);
                    AbstractMetadata metadata = metadataUtils.findOne(id);
                    preview.addContent(Diff.diff((String)metadata.getData(), (String)Xml.getString((Element)record), (DiffType)diffType));
                    continue;
                }
                preview.addContent(record.detach());
            }
            if (appendFirst) {
                Path xslProcessing = this.schemaMan.getSchemaDir(schema).resolve("process").resolve(process + ".xsl");
                if (process.endsWith(".csv")) {
                    StringWriter sw = new StringWriter();
                    Xml.transform((Element)mergedDocuments, (Path)xslProcessing, (Result)new StreamResult(sw), null);
                    String string = sw.toString();
                    return string;
                }
                Element element = Xml.transform((Element)mergedDocuments, (Path)xslProcessing);
                return element;
            }
        }
        catch (Exception exception) {
            xslProcessingReport.addError(exception);
        }
        finally {
            xslProcessingReport.close();
        }
        if (xslProcessingReport.getErrors().size() > 0) {
            response.setHeader("Content-Type", "application/json");
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writeValueAsString((Object)xslProcessingReport);
            }
            catch (JsonProcessingException errorReportException) {
                return String.format("Failed to generate error report due to '%s'.", errorReportException.getMessage());
            }
        }
        return isText ? output.toString() : preview;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Apply a process to one or more records", description="Process a metadata with an XSL transformation declared in the metadata schema (See the process folder). Parameters sent to the service are forwarded to XSL process.")
    @RequestMapping(value={"/{process:.+}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Report about processed records."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    public XsltMetadataProcessingReport processRecords(@Parameter(description="Process identifier") @PathVariable String process, @Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="If true updates the DateStamp (or equivalent in standards different to ISO 19139) field in the metadata with the current timestamp", required=false) @RequestParam(required=false, defaultValue="true") boolean updateDateStamp, @Parameter(description="Index after processing", required=false, example="false") @RequestParam(required=false, defaultValue="true") boolean index, @Parameter(hidden=true) HttpSession httpSession, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        try (XsltMetadataProcessingReport xslProcessingReport = new XsltMetadataProcessingReport(process);){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
            UserSession userSession = ApiUtils.getUserSession(httpSession);
            String siteURL = request.getRequestURL().toString() + "?" + request.getQueryString();
            xslProcessingReport.setTotalRecords(records.size());
            BatchXslMetadataReindexer m = new BatchXslMetadataReindexer(ApiUtils.createServiceContext(request), this.dataMan, records, process, httpSession, siteURL, xslProcessingReport, request, index, updateDateStamp, userSession.getUserIdAsInt());
            m.process(this.settingManager.getSiteId());
        }
        return xslProcessingReport;
    }

    static final class BatchXslMetadataReindexer
    extends MetadataIndexerProcessor {
        private final boolean index;
        private final boolean updateDateStamp;
        Set<String> records;
        String process;
        String siteURL;
        HttpSession session;
        XsltMetadataProcessingReport xslProcessingReport;
        HttpServletRequest request;
        ServiceContext context;
        int userId;

        public BatchXslMetadataReindexer(ServiceContext context, DataManager dm, Set<String> records, String process, HttpSession session, String siteURL, XsltMetadataProcessingReport xslProcessingReport, HttpServletRequest request, boolean index, boolean updateDateStamp, int userId) {
            super(dm);
            this.records = records;
            this.process = process;
            this.session = session;
            this.index = index;
            this.updateDateStamp = updateDateStamp;
            this.siteURL = siteURL;
            this.request = request;
            this.xslProcessingReport = xslProcessingReport;
            this.context = context;
            this.userId = userId;
        }

        public void process(String catalogueId) throws Exception {
            DataManager dataMan = (DataManager)this.context.getBean(DataManager.class);
            IMetadataUtils metadataUtils = (IMetadataUtils)this.context.getBean(IMetadataUtils.class);
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            for (String uuid : this.records) {
                List idList = metadataUtils.findAllIdsBy(MetadataSpecs.hasMetadataUuid((String)uuid));
                if (idList.size() > 1) {
                    this.xslProcessingReport.setTotalRecords(this.xslProcessingReport.getNumberOfRecords() + 1);
                }
                for (Integer id : idList) {
                    Log.info((String)"org.fao.geonet.services.metadata", (Object)("Processing metadata with id:" + id));
                    Element beforeMetadata = dataMan.getMetadata(this.context, String.valueOf(id), false, false, false);
                    XslProcessUtils.process(this.context, String.valueOf(id), this.process, true, this.index, this.updateDateStamp, this.xslProcessingReport, this.siteURL, this.request.getParameterMap());
                    Element afterMetadata = dataMan.getMetadata(this.context, String.valueOf(id), false, false, false);
                    XMLOutputter outp = new XMLOutputter();
                    String xmlAfter = outp.outputString(afterMetadata);
                    String xmlBefore = outp.outputString(beforeMetadata);
                    new RecordProcessingChangeEvent(id, Integer.valueOf(this.userId), xmlBefore, xmlAfter, this.process).publish((ApplicationContext)appContext);
                }
            }
        }
    }
}

