/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api;

import javax.xml.bind.annotation.XmlRootElement;
import org.fao.geonet.exceptions.ILocalizedException;
import org.springframework.util.StringUtils;

@XmlRootElement
public class ApiError {
    private String message;
    private String code;
    private String description;
    private Exception exception;

    public ApiError() {
    }

    public ApiError(String code) {
        this(code, null, null);
    }

    public ApiError(String code, String message) {
        this(code, message, null);
    }

    public ApiError(String code, String message, String description) {
        this.code = code;
        this.message = message;
        this.description = description;
    }

    public ApiError(String code, Exception exception) {
        this(code, exception.getClass().getSimpleName(), exception.getMessage());
        this.exception = exception;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        String localizedMessage = null;
        if (this.exception != null && this.exception instanceof ILocalizedException) {
            localizedMessage = ((ILocalizedException)this.exception).getLocalizedMessage();
        }
        if (StringUtils.isEmpty(localizedMessage)) {
            return this.message;
        }
        return localizedMessage;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDescription() {
        String localizedDescription = null;
        if (this.exception != null && this.exception instanceof ILocalizedException) {
            localizedDescription = ((ILocalizedException)this.exception).getLocalizedDescription();
        }
        if (StringUtils.isEmpty(localizedDescription)) {
            return this.description;
        }
        return localizedDescription;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

