/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.fmrc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CatalogCollectionManager;
import thredds.inventory.CollectionManager;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import thredds.inventory.NcmlCollectionReader;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.fmrc.FmrInv;
import ucar.nc2.ft.fmrc.FmrcDataset;
import ucar.nc2.ft.fmrc.FmrcInv;
import ucar.nc2.ft.fmrc.GridDatasetInv;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;

@ThreadSafe
public class Fmrc {
    private static Logger logger = LoggerFactory.getLogger(Fmrc.class);
    private final CollectionManager manager;
    private final FeatureCollectionConfig config;
    private final Object lock = new Object();
    private FmrcDataset fmrcDataset;
    private volatile boolean forceProto = false;
    private volatile long lastInvChanged;
    private volatile long lastProtoChanged;

    public static Fmrc open(String collection, Formatter errlog) throws IOException {
        if (collection.startsWith("catalog:")) {
            CatalogCollectionManager manager = new CatalogCollectionManager(collection);
            return new Fmrc(manager, new FeatureCollectionConfig());
        }
        if (collection.endsWith(".ncml")) {
            NcmlCollectionReader ncmlCollection = NcmlCollectionReader.open(collection, errlog);
            if (ncmlCollection == null) {
                return null;
            }
            Fmrc fmrc = new Fmrc(ncmlCollection.getCollectionManager(), new FeatureCollectionConfig());
            fmrc.setNcml(ncmlCollection.getNcmlOuter(), ncmlCollection.getNcmlInner());
            return fmrc;
        }
        return new Fmrc(collection, errlog);
    }

    public static Fmrc open(FeatureCollectionConfig config, Formatter errlog) throws IOException {
        if (config.spec.startsWith("catalog:")) {
            CatalogCollectionManager manager = new CatalogCollectionManager(config.spec);
            return new Fmrc(manager, config);
        }
        return new Fmrc(config, errlog);
    }

    private Fmrc(String collectionSpec, Formatter errlog) throws IOException {
        this.manager = MFileCollectionManager.open(collectionSpec, null, errlog);
        this.config = new FeatureCollectionConfig();
        this.config.spec = collectionSpec;
    }

    private Fmrc(FeatureCollectionConfig config, Formatter errlog) {
        this.manager = new MFileCollectionManager(config, errlog, null);
        this.config = config;
    }

    public Fmrc(CollectionManager manager, FeatureCollectionConfig config) {
        this.manager = manager;
        this.config = config;
    }

    public void setNcml(Element outerNcml, Element innerNcml) {
        this.config.protoConfig.outerNcml = outerNcml;
        this.config.innerNcml = innerNcml;
    }

    public void close() {
        this.manager.close();
    }

    public CollectionManager getManager() {
        return this.manager;
    }

    public FmrcInv getFmrcInv(Formatter debug) throws IOException {
        return this.makeFmrcInv(debug);
    }

    public CalendarDateRange getDateRangeForRun(CalendarDate run) {
        return this.fmrcDataset.getDateRangeForRun(run);
    }

    public CalendarDateRange getDateRangeForOffset(double offset) {
        return this.fmrcDataset.getDateRangeForOffset(offset);
    }

    public List<CalendarDate> getRunDates() throws IOException {
        this.checkNeeded(false);
        return this.fmrcDataset.getRunDates();
    }

    public List<CalendarDate> getForecastDates() throws IOException {
        this.checkNeeded(false);
        return this.fmrcDataset.getForecastDates();
    }

    public double[] getForecastOffsets() throws IOException {
        this.checkNeeded(false);
        return this.fmrcDataset.getForecastOffsets();
    }

    public GridDataset getDataset2D(NetcdfDataset result) throws IOException {
        this.checkNeeded(false);
        GridDataset gds = this.fmrcDataset.getNetcdfDataset2D(result);
        return gds;
    }

    public GridDataset getDatasetBest() throws IOException {
        this.checkNeeded(false);
        GridDataset gds = this.fmrcDataset.getBest();
        return gds;
    }

    public GridDataset getDatasetBest(FeatureCollectionConfig.BestDataset bd) throws IOException {
        this.checkNeeded(false);
        GridDataset gds = this.fmrcDataset.getBest(bd);
        return gds;
    }

    public GridDataset getRunTimeDataset(CalendarDate run) throws IOException {
        this.checkNeeded(false);
        GridDataset gds = this.fmrcDataset.getRunTimeDataset(run);
        return gds;
    }

    public GridDataset getConstantForecastDataset(CalendarDate time) throws IOException {
        this.checkNeeded(false);
        GridDataset gds = this.fmrcDataset.getConstantForecastDataset(time);
        return gds;
    }

    public GridDataset getConstantOffsetDataset(double hour) throws IOException {
        this.checkNeeded(false);
        GridDataset gds = this.fmrcDataset.getConstantOffsetDataset(hour);
        return gds;
    }

    public void updateProto() {
        this.forceProto = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object object = this.lock;
        synchronized (object) {
            boolean forceProtoLocal = this.forceProto;
            if (this.fmrcDataset == null) {
                try {
                    this.fmrcDataset = new FmrcDataset(this.config);
                }
                catch (Throwable t) {
                    logger.error(this.config.spec + ": initial fmrcDataset creation failed", t);
                }
            }
            try {
                FmrcInv fmrcInv = this.makeFmrcInv(null);
                this.fmrcDataset.setInventory(fmrcInv, forceProtoLocal);
                logger.debug(this.config.spec + ": make new Dataset, new proto = {}", (Object)forceProtoLocal);
                if (forceProtoLocal) {
                    this.forceProto = false;
                }
                this.lastInvChanged = System.currentTimeMillis();
                if (forceProtoLocal) {
                    this.lastProtoChanged = this.lastInvChanged;
                }
            }
            catch (Throwable t) {
                logger.error(this.config.spec + ": makeFmrcInv failed", t);
            }
        }
    }

    public boolean checkInvState(long lastInvChange) throws IOException {
        return this.lastInvChanged > lastInvChange;
    }

    public boolean checkProtoState(long lastProtoChanged) throws IOException {
        return this.lastProtoChanged > lastProtoChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkNeeded(boolean force) {
        Object object = this.lock;
        synchronized (object) {
            if (this.fmrcDataset == null) {
                try {
                    this.manager.scan(true);
                    this.update();
                    return;
                }
                catch (Throwable t) {
                    logger.error(this.config.spec + ": rescan failed");
                    throw new RuntimeException(t);
                }
            }
            if (!force && !this.manager.isScanNeeded()) {
                return;
            }
            try {
                if (!this.manager.scan(true)) {
                    return;
                }
                this.update();
            }
            catch (Throwable t) {
                logger.error(this.config.spec + ": rescan failed");
                throw new RuntimeException(t);
            }
        }
    }

    private FmrcInv makeFmrcInv(Formatter debug) throws IOException {
        try {
            HashMap<CalendarDate, FmrInv> fmrMap = new HashMap<CalendarDate, FmrInv>();
            ArrayList<FmrInv> fmrList = new ArrayList<FmrInv>();
            for (MFile f : this.manager.getFiles()) {
                FmrInv fmr;
                if (logger.isDebugEnabled()) {
                    logger.debug("Fmrc: " + this.config.spec + ": file=" + f.getPath());
                }
                GridDatasetInv inv = null;
                try {
                    inv = GridDatasetInv.open(this.manager, f, this.config.innerNcml);
                }
                catch (IOException ioe) {
                    logger.warn("Error opening " + f.getPath() + "(skipped)", (Throwable)ioe);
                    continue;
                }
                CalendarDate runDate = inv.getRunDate();
                if (debug != null) {
                    debug.format("  opened %s rundate = %s%n", f.getPath(), inv.getRunDateString());
                }
                if ((fmr = (FmrInv)fmrMap.get(runDate)) == null) {
                    fmr = new FmrInv(runDate);
                    fmrMap.put(runDate, fmr);
                    fmrList.add(fmr);
                }
                fmr.addDataset(inv, debug);
            }
            if (debug != null) {
                debug.format("%n", new Object[0]);
            }
            Collections.sort(fmrList);
            for (FmrInv fmr : fmrList) {
                fmr.finish();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Fmrc: spec=" + this.config.spec + ": fmr rundate=" + fmr.getRunDate() + " nfiles= " + fmr.getFiles().size());
            }
            return new FmrcInv("fmrc:" + this.manager.getCollectionName(), fmrList, this.config.fmrcConfig.regularize);
        }
        catch (Throwable t) {
            logger.error("makeFmrcInv", t);
            throw new RuntimeException(t);
        }
    }

    public void showDetails(Formatter out) throws IOException {
        this.checkNeeded(false);
        this.fmrcDataset.showDetails(out);
    }

    public static void main(String[] args) throws IOException {
        Formatter errlog = new Formatter();
        String spec1 = "/data/testdata/ncml/nc/nam_c20s/NAM_CONUS_20km_surface_#yyyyMMdd_HHmm#.grib1";
        String spec2 = "/data/testdata/grid/grib/grib1/data/agg/.*grb";
        String spec3 = "/data/testdata/ncml/nc/ruc_conus40/RUC_CONUS_40km_#yyyyMMdd_HHmm#.grib1";
        String spec4 = "/data/testdata/cdmUnitTest/rtmodels/.*_nmm\\.GrbF[0-9]{5}$";
        String cat1 = "catalog:http://motherlode.ucar.edu:8080/thredds/catalog/fmrc/NCEP/RUC2/CONUS_40km/files/catalog.xml";
        String cat2 = "catalog:http://motherlode.ucar.edu:8080/thredds/catalog/fmrc/NCEP/NDFD/CONUS_5km/files/catalog.xml";
        String specH = "C:/data/datasets/nogaps/US058GMET-GR1mdl.*air_temp";
        String specH2 = "C:/data/ft/grid/cg/.*nc$";
        String specH3 = "C:/data/ft/grid/namExtract/#yyyyMMdd_HHmm#.*nc$";
        Fmrc fmrc = new Fmrc(specH3, errlog);
        System.out.printf("errlog = %s%n", errlog);
    }
}

