/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;
import java.io.IOException;

public class DbTruncateLog {
    private long truncateFileNum = -1L;
    private long truncateOffset = -1L;
    private File envHome;

    public static void main(String[] argv) {
        try {
            DbTruncateLog truncator = new DbTruncateLog();
            truncator.parseArgs(argv);
            truncator.truncateLog();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            DbTruncateLog.usage();
            System.exit(1);
        }
    }

    private void parseArgs(String[] argv) {
        boolean seenFile = false;
        boolean seenOffset = false;
        for (int whichArg = 0; whichArg < argv.length; ++whichArg) {
            String nextArg = argv[whichArg];
            if (nextArg.equals("-h")) {
                this.envHome = new File(CmdUtil.getArg(argv, ++whichArg));
                continue;
            }
            if (nextArg.equals("-f")) {
                this.truncateFileNum = CmdUtil.readLongNumber(CmdUtil.getArg(argv, ++whichArg));
                seenFile = true;
                continue;
            }
            if (nextArg.equals("-o")) {
                this.truncateOffset = CmdUtil.readLongNumber(CmdUtil.getArg(argv, ++whichArg));
                seenOffset = true;
                continue;
            }
            throw new IllegalArgumentException(nextArg + " is not a supported option.");
        }
        if (this.envHome == null) {
            DbTruncateLog.usage();
        }
        System.exit(1);
        if (!seenFile || !seenOffset) {
            DbTruncateLog.usage();
            System.exit(1);
        }
    }

    private void truncateLog() throws IOException {
        this.truncateLog(this.envHome, this.truncateFileNum, this.truncateOffset);
    }

    public void truncateLog(File envHome, long truncateFileNum, long truncateOffset) throws IOException {
        EnvironmentImpl envImpl = CmdUtil.makeUtilityEnvironment(envHome, false);
        envImpl.getFileManager().truncateLog(truncateFileNum, truncateOffset);
        envImpl.close();
    }

    private static void usage() {
        System.out.println("Usage: " + CmdUtil.getJavaCommand(DbTruncateLog.class));
        System.out.println("                 -h <environment home>");
        System.out.println("                 -f <file number, in hex>");
        System.out.println("                 -o <offset, in hex>");
        System.out.println("Log file is truncated at position starting at and inclusive of the offset.");
    }
}

