/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.scanspec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import nonapi.io.github.classgraph.utils.CollectionUtils;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.JarUtils;

public abstract class WhiteBlackList {
    protected Set<String> whitelist;
    protected Set<String> blacklist;
    protected Set<String> whitelistPrefixesSet;
    protected List<String> whitelistPrefixes;
    protected List<String> blacklistPrefixes;
    protected Set<String> whitelistGlobs;
    protected Set<String> blacklistGlobs;
    protected transient List<Pattern> whitelistPatterns;
    protected transient List<Pattern> blacklistPatterns;
    protected char separatorChar;

    public WhiteBlackList() {
    }

    public WhiteBlackList(char separatorChar) {
        this.separatorChar = separatorChar;
    }

    public abstract void addToWhitelist(String var1);

    public abstract void addToBlacklist(String var1);

    public abstract boolean isWhitelistedAndNotBlacklisted(String var1);

    public abstract boolean isWhitelisted(String var1);

    public abstract boolean whitelistHasPrefix(String var1);

    public abstract boolean isBlacklisted(String var1);

    public static String normalizePath(String path) {
        return FileUtils.sanitizeEntryPath(path, true);
    }

    public static String normalizePackageOrClassName(String packageOrClassName) {
        return WhiteBlackList.normalizePath(packageOrClassName.replace('.', '/')).replace('/', '.');
    }

    public static String pathToPackageName(String path) {
        return path.replace('/', '.');
    }

    public static String packageNameToPath(String packageName) {
        return packageName.replace('.', '/');
    }

    public static String classNameToClassfilePath(String className) {
        return JarUtils.classNameToClassfilePath(className);
    }

    public static Pattern globToPattern(String glob) {
        return Pattern.compile("^" + glob.replace(".", "\\.").replace("*", ".*") + "$");
    }

    private static boolean matchesPatternList(String str, List<Pattern> patterns) {
        if (patterns != null) {
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(str).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean whitelistIsEmpty() {
        return this.whitelist == null && this.whitelistPrefixes == null && this.whitelistGlobs == null;
    }

    public boolean blacklistIsEmpty() {
        return this.blacklist == null && this.blacklistPrefixes == null && this.blacklistGlobs == null;
    }

    public boolean whitelistAndBlacklistAreEmpty() {
        return this.whitelistIsEmpty() && this.blacklistIsEmpty();
    }

    public boolean isSpecificallyWhitelistedAndNotBlacklisted(String str) {
        return !this.whitelistIsEmpty() && this.isWhitelistedAndNotBlacklisted(str);
    }

    public boolean isSpecificallyWhitelisted(String str) {
        return !this.whitelistIsEmpty() && this.isWhitelisted(str);
    }

    void sortPrefixes() {
        if (this.whitelistPrefixesSet != null) {
            this.whitelistPrefixes = new ArrayList<String>(this.whitelistPrefixesSet);
        }
        if (this.whitelistPrefixes != null) {
            CollectionUtils.sortIfNotEmpty(this.whitelistPrefixes);
        }
        if (this.blacklistPrefixes != null) {
            CollectionUtils.sortIfNotEmpty(this.blacklistPrefixes);
        }
    }

    private static void quoteList(Collection<String> coll, StringBuilder buf) {
        buf.append('[');
        boolean first = true;
        for (String item : coll) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append('\"');
            for (int i = 0; i < item.length(); ++i) {
                char c = item.charAt(i);
                if (c == '\"') {
                    buf.append("\\\"");
                    continue;
                }
                buf.append(c);
            }
            buf.append('\"');
        }
        buf.append(']');
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.whitelist != null) {
            buf.append("whitelist: ");
            WhiteBlackList.quoteList(this.whitelist, buf);
        }
        if (this.whitelistPrefixes != null) {
            if (buf.length() > 0) {
                buf.append("; ");
            }
            buf.append("whitelistPrefixes: ");
            WhiteBlackList.quoteList(this.whitelistPrefixes, buf);
        }
        if (this.whitelistGlobs != null) {
            if (buf.length() > 0) {
                buf.append("; ");
            }
            buf.append("whitelistGlobs: ");
            WhiteBlackList.quoteList(this.whitelistGlobs, buf);
        }
        if (this.blacklist != null) {
            if (buf.length() > 0) {
                buf.append("; ");
            }
            buf.append("blacklist: ");
            WhiteBlackList.quoteList(this.blacklist, buf);
        }
        if (this.blacklistPrefixes != null) {
            if (buf.length() > 0) {
                buf.append("; ");
            }
            buf.append("blacklistPrefixes: ");
            WhiteBlackList.quoteList(this.blacklistPrefixes, buf);
        }
        if (this.blacklistGlobs != null) {
            if (buf.length() > 0) {
                buf.append("; ");
            }
            buf.append("blacklistGlobs: ");
            WhiteBlackList.quoteList(this.blacklistGlobs, buf);
        }
        return buf.toString();
    }

    public static class WhiteBlackListLeafname
    extends WhiteBlackListWholeString {
        public WhiteBlackListLeafname() {
        }

        public WhiteBlackListLeafname(char separatorChar) {
            super(separatorChar);
        }

        @Override
        public void addToWhitelist(String str) {
            super.addToWhitelist(JarUtils.leafName(str));
        }

        @Override
        public void addToBlacklist(String str) {
            super.addToBlacklist(JarUtils.leafName(str));
        }

        @Override
        public boolean isWhitelistedAndNotBlacklisted(String str) {
            return super.isWhitelistedAndNotBlacklisted(JarUtils.leafName(str));
        }

        @Override
        public boolean isWhitelisted(String str) {
            return super.isWhitelisted(JarUtils.leafName(str));
        }

        @Override
        public boolean whitelistHasPrefix(String str) {
            throw new IllegalArgumentException("Can only find prefixes of whole strings");
        }

        @Override
        public boolean isBlacklisted(String str) {
            return super.isBlacklisted(JarUtils.leafName(str));
        }
    }

    public static class WhiteBlackListWholeString
    extends WhiteBlackList {
        public WhiteBlackListWholeString() {
        }

        public WhiteBlackListWholeString(char separatorChar) {
            super(separatorChar);
        }

        @Override
        public void addToWhitelist(String str) {
            if (str.contains("*")) {
                if (this.whitelistGlobs == null) {
                    this.whitelistGlobs = new HashSet();
                    this.whitelistPatterns = new ArrayList();
                }
                this.whitelistGlobs.add(str);
                this.whitelistPatterns.add(WhiteBlackListWholeString.globToPattern(str));
            } else {
                if (this.whitelist == null) {
                    this.whitelist = new HashSet();
                }
                this.whitelist.add(str);
            }
            if (this.whitelistPrefixesSet == null) {
                this.whitelistPrefixesSet = new HashSet();
                this.whitelistPrefixesSet.add("");
                this.whitelistPrefixesSet.add("/");
            }
            String separator = Character.toString(this.separatorChar);
            String prefix = str;
            if (prefix.contains("*")) {
                int sepIdx = (prefix = prefix.substring(0, prefix.indexOf(42))).lastIndexOf(this.separatorChar);
                prefix = sepIdx < 0 ? "" : prefix.substring(0, prefix.lastIndexOf(this.separatorChar));
            }
            while (prefix.endsWith(separator)) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            while (!prefix.isEmpty()) {
                this.whitelistPrefixesSet.add(prefix + this.separatorChar);
                prefix = FileUtils.getParentDirPath(prefix, this.separatorChar);
            }
        }

        @Override
        public void addToBlacklist(String str) {
            if (str.contains("*")) {
                if (this.blacklistGlobs == null) {
                    this.blacklistGlobs = new HashSet();
                    this.blacklistPatterns = new ArrayList();
                }
                this.blacklistGlobs.add(str);
                this.blacklistPatterns.add(WhiteBlackListWholeString.globToPattern(str));
            } else {
                if (this.blacklist == null) {
                    this.blacklist = new HashSet();
                }
                this.blacklist.add(str);
            }
        }

        @Override
        public boolean isWhitelistedAndNotBlacklisted(String str) {
            return this.isWhitelisted(str) && !this.isBlacklisted(str);
        }

        @Override
        public boolean isWhitelisted(String str) {
            return this.whitelist == null && this.whitelistPatterns == null || this.whitelist != null && this.whitelist.contains(str) || WhiteBlackList.matchesPatternList(str, this.whitelistPatterns);
        }

        @Override
        public boolean whitelistHasPrefix(String str) {
            if (this.whitelistPrefixesSet == null) {
                return false;
            }
            return this.whitelistPrefixesSet.contains(str);
        }

        @Override
        public boolean isBlacklisted(String str) {
            return this.blacklist != null && this.blacklist.contains(str) || WhiteBlackList.matchesPatternList(str, this.blacklistPatterns);
        }
    }

    public static class WhiteBlackListPrefix
    extends WhiteBlackList {
        public WhiteBlackListPrefix() {
        }

        public WhiteBlackListPrefix(char separatorChar) {
            super(separatorChar);
        }

        @Override
        public void addToWhitelist(String str) {
            if (str.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + str);
            }
            if (this.whitelistPrefixesSet == null) {
                this.whitelistPrefixesSet = new HashSet();
            }
            this.whitelistPrefixesSet.add(str);
        }

        @Override
        public void addToBlacklist(String str) {
            if (str.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + str);
            }
            if (this.blacklistPrefixes == null) {
                this.blacklistPrefixes = new ArrayList();
            }
            this.blacklistPrefixes.add(str);
        }

        @Override
        public boolean isWhitelistedAndNotBlacklisted(String str) {
            boolean isWhitelisted;
            boolean bl = isWhitelisted = this.whitelistPrefixes == null;
            if (!isWhitelisted) {
                for (String prefix : this.whitelistPrefixes) {
                    if (!str.startsWith(prefix)) continue;
                    isWhitelisted = true;
                    break;
                }
            }
            if (!isWhitelisted) {
                return false;
            }
            if (this.blacklistPrefixes != null) {
                for (String prefix : this.blacklistPrefixes) {
                    if (!str.startsWith(prefix)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean isWhitelisted(String str) {
            boolean isWhitelisted;
            boolean bl = isWhitelisted = this.whitelistPrefixes == null;
            if (!isWhitelisted) {
                for (String prefix : this.whitelistPrefixes) {
                    if (!str.startsWith(prefix)) continue;
                    isWhitelisted = true;
                    break;
                }
            }
            return isWhitelisted;
        }

        @Override
        public boolean whitelistHasPrefix(String str) {
            throw new IllegalArgumentException("Can only find prefixes of whole strings");
        }

        @Override
        public boolean isBlacklisted(String str) {
            if (this.blacklistPrefixes != null) {
                for (String prefix : this.blacklistPrefixes) {
                    if (!str.startsWith(prefix)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

