/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.ogcwxs;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Logger;
import org.fao.geonet.api.records.attachments.FilesystemStore;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.harvest.BaseAligner;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.GroupMapper;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.IHarvester;
import org.fao.geonet.kernel.harvest.harvester.UUIDMapper;
import org.fao.geonet.kernel.harvest.harvester.ogcwxs.OgcWxSParams;
import org.fao.geonet.kernel.schema.ISOPlugin;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.util.Sha1Encoder;
import org.fao.geonet.utils.AbstractHttpRequest;
import org.fao.geonet.utils.BinaryFile;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;

class Harvester
extends BaseAligner<OgcWxSParams>
implements IHarvester<HarvestResult> {
    private static final int WIDTH = 900;
    private static final String GETCAPABILITIES = "GetCapabilities";
    private static final String GETMAP = "GetMap";
    private static final String IMAGE_FORMAT = "image/png";
    private Logger log;
    private ServiceContext context;
    private DataManager dataMan;
    private IMetadataManager metadataManager;
    private SchemaManager schemaMan;
    private CategoryMapper localCateg;
    private GroupMapper localGroups;
    private HarvestResult result;
    private String capabilitiesUrl;
    private List<WxSLayerRegistry> layersRegistry = new ArrayList<WxSLayerRegistry>();

    public Harvester(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, OgcWxSParams params) {
        super(cancelMonitor);
        this.log = log;
        this.context = context;
        this.params = params;
        this.result = new HarvestResult();
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        this.dataMan = (DataManager)gc.getBean(DataManager.class);
        this.schemaMan = (SchemaManager)gc.getBean(SchemaManager.class);
        this.metadataManager = (IMetadataManager)gc.getBean(IMetadataManager.class);
    }

    @Override
    public HarvestResult harvest(Logger log) throws Exception {
        this.log = log;
        log.info("Retrieving remote metadata information for : " + ((OgcWxSParams)this.params).getName());
        UUIDMapper localUuids = new UUIDMapper((IMetadataUtils)this.context.getBean(IMetadataUtils.class), ((OgcWxSParams)this.params).getUuid());
        String serviceType = ((OgcWxSParams)this.params).ogctype.substring(0, 3);
        String version = ((OgcWxSParams)this.params).ogctype.substring(3);
        boolean isSos = "SOS".equals(serviceType);
        this.capabilitiesUrl = this.getBaseUrl(((OgcWxSParams)this.params).url) + "SERVICE=" + serviceType + (isSos ? "" : "&VERSION=" + version) + "&REQUEST=" + GETCAPABILITIES;
        if (log.isDebugEnabled()) {
            log.debug("GetCapabilities document: " + this.capabilitiesUrl);
        }
        XmlRequest req = ((GeonetHttpRequestFactory)this.context.getBean(GeonetHttpRequestFactory.class)).createXmlRequest();
        req.setUrl(new URL(this.capabilitiesUrl));
        req.setMethod(AbstractHttpRequest.Method.GET);
        Lib.net.setupProxy(this.context, req);
        if (((OgcWxSParams)this.params).isUseAccount()) {
            req.setCredentials(((OgcWxSParams)this.params).getUsername(), ((OgcWxSParams)this.params).getPassword());
        }
        Element xml = req.execute();
        List<String> uuids = this.addMetadata(xml);
        this.metadataManager.flush();
        List ids = Lists.transform(uuids, (Function)new Function<String, String>(){

            @Nullable
            public String apply(@Nonnull String uuid) {
                try {
                    return Harvester.this.dataMan.getMetadataId(uuid);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
        this.dataMan.batchIndexInThreadPool(this.context, ids);
        this.result.totalMetadata = this.result.addedMetadata + this.result.updatedMetadata;
        Store store = (Store)this.context.getBean("resourceStore", Store.class);
        for (String uuid : localUuids.getUUIDs()) {
            if (this.cancelMonitor.get()) {
                return this.result;
            }
            if (uuids.contains(uuid)) continue;
            String id = localUuids.getID(uuid);
            if (log.isDebugEnabled()) {
                log.debug("  - Removing old metadata before update with id: " + id);
            }
            store.delResources(this.context, uuid);
            this.metadataManager.deleteMetadata(this.context, id);
            ++this.result.locallyRemoved;
        }
        if (this.result.locallyRemoved > 0) {
            this.metadataManager.flush();
        }
        return this.result;
    }

    private List<String> addMetadata(Element capa) throws Exception {
        String id;
        if (capa == null) {
            return Collections.emptyList();
        }
        LinkedList<String> uuids = new LinkedList<String>();
        this.localCateg = new CategoryMapper(this.context);
        this.localGroups = new GroupMapper(this.context);
        String uuid = Sha1Encoder.encodeString((String)this.capabilitiesUrl);
        boolean usingTemplate = StringUtils.isNotBlank((String)((OgcWxSParams)this.params).serviceTemplateUuid);
        Element md = null;
        HashMap<String, Object> xsltParams = new HashMap<String, Object>();
        xsltParams.put("lang", ((OgcWxSParams)this.params).lang);
        xsltParams.put("topic", ((OgcWxSParams)this.params).topic);
        xsltParams.put("uuid", uuid);
        md = usingTemplate ? this.buildRecordFromTemplateOrExisting(uuid, xsltParams, capa, ((OgcWxSParams)this.params).serviceTemplateUuid) : this.buildServiceRecordFromCapabilities(xsltParams, capa);
        String schema = this.dataMan.autodetectSchema(md, null);
        if (schema == null) {
            this.log.warning("Skipping metadata with unknown schema.");
            ++this.result.unknownSchema;
        }
        if (((OgcWxSParams)this.params).useLayer || ((OgcWxSParams)this.params).useLayerMd) {
            XPath xp = XPath.newInstance((String)"//Layer[count(./*[name(.)='Layer'])=0] | //wms:Layer[count(./*[name(.)='Layer'])=0] | //wmts:Layer[count(./*[local-name(.)='Layer'])=0] | //wfs:FeatureType | //wcs:CoverageOfferingBrief | //sos:ObservationOffering | //wps:ProcessSummary");
            xp.addNamespace("wfs", "http://www.opengis.net/wfs");
            xp.addNamespace("wcs", "http://www.opengis.net/wcs");
            xp.addNamespace("wms", "http://www.opengis.net/wms");
            xp.addNamespace("wmts", "http://www.opengis.net/wmts/1.0");
            xp.addNamespace("wps", "http://www.opengis.net/wps/2.0");
            xp.addNamespace("sos", "http://www.opengis.net/sos/1.0");
            Document document = new Document();
            Element clone = (Element)capa.clone();
            document.addContent((Content)clone);
            List layers = xp.selectNodes((Object)document);
            if (layers.size() > 0) {
                this.log.info("  - Number of layers, featureTypes, Coverages or process found : " + layers.size());
                for (Element layer : layers) {
                    WxSLayerRegistry s = this.addLayerMetadata(layer, capa);
                    if (s == null) continue;
                    uuids.add(s.uuid);
                    this.layersRegistry.add(s);
                }
                md = this.addOperatesOnUuid(md, schema, this.layersRegistry);
            }
        }
        Path importXsl = this.context.getAppPath().resolve("xsl/conversion/import");
        String importXslFile = ((OgcWxSParams)this.params).getImportXslt();
        if (importXslFile != null && !importXslFile.equals("none")) {
            if (!importXslFile.endsWith("xsl")) {
                importXslFile = importXslFile + ".xsl";
            }
            importXsl = importXsl.resolve(importXslFile);
            this.log.info("Applying custom import XSL " + importXsl.getFileName());
            md = Xml.transform((Element)md, (Path)importXsl);
        }
        this.log.info("  - Adding metadata for services with " + uuid);
        Metadata metadata = new Metadata();
        metadata.setUuid(uuid);
        metadata.getDataInfo().setSchemaId(schema).setRoot(md.getQualifiedName()).setType(MetadataType.METADATA);
        metadata.getSourceInfo().setSourceId(((OgcWxSParams)this.params).getUuid()).setOwner(Integer.valueOf(this.getOwner()));
        metadata.getHarvestInfo().setHarvested(true).setUuid(((OgcWxSParams)this.params).getUuid()).setUri(((OgcWxSParams)this.params).url);
        try {
            metadata.getSourceInfo().setGroupOwner(Integer.valueOf(((OgcWxSParams)this.params).getOwnerIdGroup()));
        }
        catch (NumberFormatException layers) {
            // empty catch block
        }
        this.addCategories((AbstractMetadata)metadata, ((OgcWxSParams)this.params).getCategories(), this.localCateg, this.context, null, false);
        if (!this.dataMan.existsMetadataUuid(uuid)) {
            ++this.result.addedMetadata;
            metadata = this.metadataManager.insertMetadata(this.context, (AbstractMetadata)metadata, md, false, false, UpdateDatestamp.NO, false, false);
        } else {
            ++this.result.updatedMetadata;
            id = this.dataMan.getMetadataId(uuid);
            metadata.setId(Integer.valueOf(id).intValue());
            this.metadataManager.updateMetadata(this.context, id, md, false, false, false, this.context.getLanguage(), this.dataMan.extractDateModified(schema, md), false);
        }
        id = String.valueOf(metadata.getId());
        uuids.add(uuid);
        this.addPrivileges(id, ((OgcWxSParams)this.params).getPrivileges(), this.localGroups, this.context);
        return uuids;
    }

    private Element buildServiceRecordFromCapabilities(Map<String, Object> xsltParams, Element capa) throws Exception {
        Element md;
        Path styleSheet = this.schemaMan.getSchemaDir(((OgcWxSParams)this.params).outputSchema).resolve("convert/").resolve("OGCWxSGetCapabilitiesto19119").resolve("OGC" + ((OgcWxSParams)this.params).ogctype.substring(0, 3) + "GetCapabilities-to-ISO19119_ISO19139.xsl");
        if (this.log.isDebugEnabled()) {
            this.log.debug("  - XSLT transformation using " + styleSheet);
        }
        try {
            md = Xml.transform((Element)capa, (Path)styleSheet, xsltParams);
        }
        catch (Exception e) {
            String message = String.format("Failed to convert GetCapabilities '%s' to metadata record. Error is: '%s'. Service response is: %s.", this.capabilitiesUrl, e.getMessage(), Xml.getString((Element)capa));
            this.log.error(message);
            throw new IllegalStateException(message, e);
        }
        return md;
    }

    private Element buildRecordFromTemplateOrExisting(String uuid, Map<String, Object> xsltParams, Element capa, String templateUuid) throws Exception {
        Element md;
        Element existingRecordXml;
        MetadataRepository metadataRepository = (MetadataRepository)ApplicationContextHolder.get().getBean(MetadataRepository.class);
        Metadata existingRecord = metadataRepository.findOneByUuid(uuid);
        String schema = null;
        if (existingRecord != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("  - Building record from existing one %s.", uuid));
            }
            existingRecordXml = existingRecord.getXmlData(false);
            schema = existingRecord.getDataInfo().getSchemaId();
        } else {
            String templateId = this.dataMan.getMetadataId(templateUuid);
            if (templateId == null) {
                String message = String.format("Template with UUID '%s' not found in the catalogue. Choose another template.", templateUuid);
                this.log.error(message);
                throw new IllegalStateException(message);
            }
            existingRecordXml = this.metadataManager.getMetadata(templateId);
            schema = this.dataMan.getMetadataSchema(templateId);
        }
        Element record = new Element("record");
        record.addContent((Content)existingRecordXml);
        Element getCapabilities = new Element("getCapabilities");
        Element clone = (Element)capa.clone();
        getCapabilities.addContent((Content)clone);
        Element root = new Element("root");
        root.addContent((Content)record);
        root.addContent((Content)getCapabilities);
        Path styleSheet = this.schemaMan.getSchemaDir(schema).resolve("convert/").resolve("ogcwxs-info-injection.xsl");
        if (!Files.exists(styleSheet, new LinkOption[0])) {
            String message = String.format("Transformation does not exist for this template schema '%s'. Choose another template or create the XSLT in %s/convert/ogcwxs-info-injection.xsl.", schema, schema);
            this.log.error(message);
            throw new IllegalStateException(message);
        }
        try {
            md = Xml.transform((Element)root, (Path)styleSheet, xsltParams);
        }
        catch (IllegalStateException e) {
            String message = String.format("Failed to inject GetCapabilities '%s' to service template. Error is: '%s'. Service response is: %s.", this.capabilitiesUrl, e.getMessage(), Xml.getString((Element)capa));
            this.log.error(message);
            throw new IllegalStateException(message, e);
        }
        return md;
    }

    private Element addOperatesOnUuid(Element md, String schema, List<WxSLayerRegistry> layersRegistry) {
        HashMap<String, String> layers = new HashMap<String, String>();
        for (WxSLayerRegistry wxSLayerRegistry : layersRegistry) {
            layers.put(wxSLayerRegistry.uuid, wxSLayerRegistry.name);
        }
        SchemaPlugin plugin = this.dataMan.getSchema(schema).getSchemaPlugin();
        boolean isISOPlugin = plugin instanceof ISOPlugin;
        if (isISOPlugin) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - add SV_CoupledResource and OperatesOnUuid to service metadata record.");
            }
            ((ISOPlugin)plugin).addOperatesOn(md, layers, ((OgcWxSParams)this.params).ogctype, ((SettingManager)this.context.getBean(SettingManager.class)).getNodeURL());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("  - Can't add SV_CoupledResource and OperatesOnUuid to service metadata record. This is not an ISOPlugin record.");
        }
        return md;
    }

    private WxSLayerRegistry addLayerMetadata(Element layer, Element capa) throws JDOMException {
        String schema;
        boolean loaded;
        Element xml;
        WxSLayerRegistry reg;
        block60: {
            Namespace ows;
            reg = new WxSLayerRegistry();
            xml = null;
            loaded = false;
            if (((OgcWxSParams)this.params).ogctype.substring(0, 3).equals("WMS")) {
                Element name;
                if (((OgcWxSParams)this.params).ogctype.substring(3, 8).equals("1.3.0")) {
                    Namespace wms = Namespace.getNamespace((String)"http://www.opengis.net/wms");
                    name = layer.getChild("Name", wms);
                } else {
                    name = layer.getChild("Name");
                }
                if (name == null || name.getValue().trim().equals("")) {
                    this.log.info("  - skipping layer with no name element");
                    return null;
                }
                reg.name = name.getValue();
            } else if (((OgcWxSParams)this.params).ogctype.substring(0, 3).equals("WFS")) {
                Namespace wfs = Namespace.getNamespace((String)"http://www.opengis.net/wfs");
                reg.name = layer.getChild("Name", wfs).getValue();
            } else if (((OgcWxSParams)this.params).ogctype.substring(0, 3).equals("WCS")) {
                Namespace wcs = Namespace.getNamespace((String)"http://www.opengis.net/wcs");
                reg.name = layer.getChild("name", wcs).getValue();
            } else if (((OgcWxSParams)this.params).ogctype.substring(0, 3).equals("WPS")) {
                ows = Namespace.getNamespace((String)"http://www.opengis.net/ows/2.0");
                reg.name = layer.getChild("Identifier", ows).getValue();
            } else if (((OgcWxSParams)this.params).ogctype.substring(0, 3).equals("SOS")) {
                Namespace gml = Namespace.getNamespace((String)"http://www.opengis.net/gml");
                reg.name = layer.getChild("name", gml).getValue();
            } else if (((OgcWxSParams)this.params).ogctype.substring(0, 4).equals("WMTS")) {
                ows = Namespace.getNamespace((String)"http://www.opengis.net/ows/1.1");
                reg.name = layer.getChild("Identifier", ows).getValue();
            }
            reg.uuid = Sha1Encoder.encodeString((String)(((OgcWxSParams)this.params).url + "#" + reg.name));
            this.log.info("  - Loading layer: " + reg.name + " with UUID " + reg.uuid + " (hash of capabilities URL + layer name).");
            if (((OgcWxSParams)this.params).useLayerMd && (((OgcWxSParams)this.params).ogctype.substring(0, 3).equals("WMS") || ((OgcWxSParams)this.params).ogctype.substring(0, 3).equals("WFS") || ((OgcWxSParams)this.params).ogctype.substring(0, 3).equals("WPS") || ((OgcWxSParams)this.params).ogctype.substring(0, 3).equals("WCS"))) {
                boolean addNsPrefix;
                this.log.info("  - Searching for metadataUrl for layer " + reg.name);
                Namespace xlink = Namespace.getNamespace((String)"http://www.w3.org/1999/xlink");
                String dummyNsPrefix = "";
                boolean bl = addNsPrefix = !layer.getNamespace().equals((Object)Namespace.NO_NAMESPACE);
                if (addNsPrefix) {
                    dummyNsPrefix = "x:";
                }
                Element onLineSrc = null;
                XPath mdUrlXpath = null;
                String mdXml = null;
                if (((OgcWxSParams)this.params).ogctype.startsWith("WFS1")) {
                    mdUrlXpath = XPath.newInstance((String)("./" + dummyNsPrefix + "MetadataURL[@type='TC211' and (@format='XML' or @format='text/xml')]"));
                    if (addNsPrefix) {
                        mdUrlXpath.addNamespace("x", layer.getNamespace().getURI());
                    }
                    if ((onLineSrc = (Element)mdUrlXpath.selectSingleNode((Object)layer)) != null) {
                        mdXml = onLineSrc.getText();
                    }
                } else if (((OgcWxSParams)this.params).ogctype.startsWith("WPS")) {
                    Attribute href;
                    Namespace ows2 = Namespace.getNamespace((String)"http://www.opengis.net/ows/2.0");
                    Element metadata = layer.getChild("Metadata", ows2);
                    if (metadata != null && (href = metadata.getAttribute("href", xlink)) != null) {
                        mdXml = href.getValue();
                    }
                } else {
                    Attribute href;
                    mdUrlXpath = XPath.newInstance((String)("./" + dummyNsPrefix + "MetadataURL[(@type='TC211' or @type='ISO19115:2003') and " + dummyNsPrefix + "Format='text/xml']/" + dummyNsPrefix + "OnlineResource"));
                    if (addNsPrefix) {
                        mdUrlXpath.addNamespace("x", layer.getNamespace().getURI());
                    }
                    if ((onLineSrc = (Element)mdUrlXpath.selectSingleNode((Object)layer)) != null && (href = onLineSrc.getAttribute("href", xlink)) != null) {
                        mdXml = href.getValue();
                    }
                }
                if (mdXml != null) {
                    try {
                        xml = Xml.loadFile((URL)new URL(mdXml));
                        boolean isUsingTemplate = StringUtils.isNotEmpty((String)((OgcWxSParams)this.params).datasetTemplateUuid);
                        if (xml.getName().equals("GetRecordByIdResponse")) {
                            xml = (Element)xml.getChildren().get(0);
                        } else if (xml.getName().equals("ProcessOfferings")) {
                            HashMap<String, Object> xsltParams = new HashMap<String, Object>();
                            xsltParams.put("lang", ((OgcWxSParams)this.params).lang);
                            xsltParams.put("topic", ((OgcWxSParams)this.params).topic);
                            xsltParams.put("Name", reg.name);
                            xsltParams.put("serviceType", ((OgcWxSParams)this.params).ogctype.substring(0, 3));
                            xsltParams.put("uuid", reg.uuid);
                            if (isUsingTemplate) {
                                xml = this.buildRecordFromTemplateOrExisting(reg.uuid, xsltParams, xml, ((OgcWxSParams)this.params).datasetTemplateUuid);
                            } else {
                                this.log.warning(String.format("    Building record for WPS process is only supported when a template for the layer is defined. Choose a template. Process '%s' was not converted to metadata record.", reg.name));
                            }
                        }
                        schema = this.dataMan.autodetectSchema(xml, null);
                        reg.uuid = this.dataMan.extractUUID(schema, xml);
                        boolean exist = this.dataMan.existsMetadataUuid(reg.uuid);
                        if (exist && !isUsingTemplate) {
                            this.log.warning(String.format("    Metadata uuid '%s' already exist in the catalogue. Metadata for layer '%s' will not be loaded.", reg.uuid, reg.name));
                            ++this.result.layerUuidExist;
                            return reg;
                        }
                        if (schema == null) {
                            this.log.warning(String.format("    Failed to detect schema from metadataUrl '%s' file.", mdXml));
                            ++this.result.unknownSchema;
                            loaded = false;
                            break block60;
                        }
                        this.log.info(String.format("  - MetadataUrl document '%s' for layer '%s' accepted.", mdXml, reg.name));
                        loaded = true;
                        ++this.result.layerUsingMdUrl;
                    }
                    catch (Exception e) {
                        this.log.warning(String.format("  - Failed to load layer using metadataUrl attribute '%s'. Error is: '%s'", mdXml, e.getMessage()));
                        loaded = false;
                    }
                } else {
                    this.log.info(String.format("  - No metadataUrl attribute found for layer '%s'", reg.name));
                    loaded = false;
                }
            }
        }
        if (!loaded && ((OgcWxSParams)this.params).useLayer) {
            try {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("uuid", reg.uuid);
                param.put("Name", reg.name);
                param.put("serviceType", ((OgcWxSParams)this.params).ogctype.substring(0, 3));
                param.put("lang", ((OgcWxSParams)this.params).lang);
                param.put("topic", ((OgcWxSParams)this.params).topic);
                boolean isUsingTemplate = StringUtils.isNotEmpty((String)((OgcWxSParams)this.params).datasetTemplateUuid);
                if (isUsingTemplate) {
                    xml = this.buildRecordFromTemplateOrExisting(reg.uuid, param, capa, ((OgcWxSParams)this.params).datasetTemplateUuid);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("  - Dataset record built using GetCapabilities and template.");
                    }
                } else {
                    Path styleSheet = this.schemaMan.getSchemaDir(((OgcWxSParams)this.params).outputSchema).resolve("convert/").resolve("OGCWxSGetCapabilitiesto19119").resolve("OGC" + ((OgcWxSParams)this.params).ogctype.substring(0, 3) + "GetCapabilitiesLayer-to-19139.xsl");
                    xml = Xml.transform((Element)capa, (Path)styleSheet, param);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("  - Layer loaded using GetCapabilities document.");
                    }
                }
            }
            catch (Exception e) {
                this.log.warning("  - Failed to do XSLT transformation on Layer element : " + e.getMessage());
            }
        }
        try {
            schema = this.dataMan.autodetectSchema(xml);
            Metadata metadata = new Metadata();
            metadata.setUuid(reg.uuid);
            metadata.getDataInfo().setSchemaId(schema).setRoot(xml.getQualifiedName()).setType(MetadataType.METADATA);
            metadata.getSourceInfo().setSourceId(((OgcWxSParams)this.params).getUuid()).setOwner(Integer.valueOf(Integer.parseInt(StringUtils.isNotEmpty((String)((OgcWxSParams)this.params).getOwnerIdUser()) && StringUtils.isNumeric((String)((OgcWxSParams)this.params).getOwnerIdUser()) ? ((OgcWxSParams)this.params).getOwnerIdUser() : ((OgcWxSParams)this.params).getOwnerId())));
            metadata.getHarvestInfo().setHarvested(true).setUuid(((OgcWxSParams)this.params).getUuid()).setUri(((OgcWxSParams)this.params).url);
            if (((OgcWxSParams)this.params).datasetCategory != null && !((OgcWxSParams)this.params).datasetCategory.equals("")) {
                MetadataCategory metadataCategory = (MetadataCategory)((MetadataCategoryRepository)this.context.getBean(MetadataCategoryRepository.class)).findById((Object)Integer.parseInt(((OgcWxSParams)this.params).datasetCategory)).get();
                if (metadataCategory == null) {
                    throw new IllegalArgumentException("No category found with name: " + ((OgcWxSParams)this.params).datasetCategory);
                }
                metadata.getCategories().add(metadataCategory);
            }
            if (!this.dataMan.existsMetadataUuid(reg.uuid)) {
                ++this.result.addedMetadata;
                metadata = this.metadataManager.insertMetadata(this.context, (AbstractMetadata)metadata, xml, false, false, UpdateDatestamp.NO, false, false);
            } else {
                ++this.result.updatedMetadata;
                String id = this.dataMan.getMetadataId(reg.uuid);
                metadata.setId(Integer.valueOf(id).intValue());
                this.metadataManager.updateMetadata(this.context, id, xml, false, false, false, this.context.getLanguage(), this.dataMan.extractDateModified(schema, xml), false);
            }
            reg.id = String.valueOf(metadata.getId());
            if (this.log.isDebugEnabled()) {
                this.log.debug("    - Layer loaded in DB.");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("    - Set Privileges and category.");
            }
            this.addPrivileges(reg.id, ((OgcWxSParams)this.params).getPrivileges(), this.localGroups, this.context);
            if (this.log.isDebugEnabled()) {
                this.log.debug("    - Set Harvested.");
            }
            try {
                SchemaPlugin plugin = this.dataMan.getSchema(schema).getSchemaPlugin();
                boolean isISOPlugin = plugin instanceof ISOPlugin;
                if (((OgcWxSParams)this.params).ogctype.startsWith("WMS") && ((OgcWxSParams)this.params).createThumbnails && isISOPlugin) {
                    List extents = ((ISOPlugin)plugin).getExtents(xml);
                    if (extents.size() > 0) {
                        reg.minx = ((ISOPlugin.Extent)extents.get((int)0)).xmin;
                        reg.maxx = ((ISOPlugin.Extent)extents.get((int)0)).xmax;
                        reg.miny = ((ISOPlugin.Extent)extents.get((int)0)).ymin;
                        reg.maxy = ((ISOPlugin.Extent)extents.get((int)0)).ymax;
                    } else {
                        this.log.warning("  - Failed to extract layer bbox from metadata. It looks to be null.");
                    }
                    xml = this.loadThumbnail(reg, xml, schema);
                    if (xml != null) {
                        this.metadataManager.updateMetadata(this.context, reg.id, xml, false, false, false, this.context.getLanguage(), this.dataMan.extractDateModified(schema, xml), false);
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("  - Can't get bounding boxes for that record. This is not an ISOPlugin record.");
                }
            }
            catch (Exception e) {
                this.log.warning("  - Failed to extract layer bbox from metadata : " + e.getMessage());
            }
            ++this.result.layer;
            this.log.info("  - metadata loaded with uuid: " + reg.uuid + "/internal id: " + reg.id);
        }
        catch (Exception e) {
            this.log.warning(String.format("  - Failed to load metadata document for layer '%s'. Error is: '%s',", reg.name, e.getMessage()));
            ++this.result.unretrievable;
            return null;
        }
        return reg;
    }

    private Element loadThumbnail(WxSLayerRegistry layer, Element xml, String schema) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("  - Creating thumbnail for layer metadata: " + layer.name + " id: " + layer.id);
        }
        try {
            Path filename = this.getMapThumbnail(layer);
            Store store = (Store)this.context.getBean(FilesystemStore.class);
            try {
                store.delResource(this.context, layer.uuid, filename.getFileName().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            MetadataResource resource = store.putResource(this.context, layer.uuid, filename, MetadataResourceVisibility.PUBLIC);
            Path xslProcessing = this.schemaMan.getSchemaDir(schema).resolve("process").resolve("thumbnail-add.xsl");
            if (Files.exists(xslProcessing, new LinkOption[0])) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("thumbnail_url", resource.getUrl());
                xml = Xml.transform((Element)xml, (Path)xslProcessing, params);
                ++this.result.thumbnails;
                return xml;
            }
            return null;
        }
        catch (Exception e) {
            this.log.warning("  - Failed to set thumbnail for metadata: " + e.getMessage());
            this.log.error((Throwable)e);
            ++this.result.thumbnailsFailed;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path getMapThumbnail(WxSLayerRegistry layer) {
        Path file;
        block33: {
            String bboxParamValue;
            String crsParamName;
            String filename = layer.uuid + ".png";
            file = this.context.getUploadDir().resolve(filename);
            Double r = 900.0 / (layer.maxx - layer.minx) * (layer.maxy - layer.miny);
            if (((OgcWxSParams)this.params).ogctype.substring(3).equals("1.3.0")) {
                crsParamName = "CRS";
                bboxParamValue = layer.miny + "," + layer.minx + "," + layer.maxy + "," + layer.maxx;
            } else {
                crsParamName = "SRS";
                bboxParamValue = layer.minx + "," + layer.miny + "," + layer.maxx + "," + layer.maxy;
            }
            String url = this.getBaseUrl(((OgcWxSParams)this.params).url) + "&SERVICE=" + ((OgcWxSParams)this.params).ogctype.substring(0, 3) + "&VERSION=" + ((OgcWxSParams)this.params).ogctype.substring(3) + "&REQUEST=" + GETMAP + "&FORMAT=" + IMAGE_FORMAT + "&WIDTH=" + 900 + "&" + crsParamName + "=EPSG:4326&HEIGHT=" + r.intValue() + "&LAYERS=" + layer.name + "&STYLES=&BBOX=" + bboxParamValue;
            this.log.info("Retrieving thumbnail from URL: " + url);
            HttpGet req = new HttpGet(url);
            try {
                GeonetHttpRequestFactory requestFactory = (GeonetHttpRequestFactory)this.context.getBean(GeonetHttpRequestFactory.class);
                final String requestHost = req.getURI().getHost();
                ClientHttpResponse httpResponse = requestFactory.execute((HttpUriRequest)req, (Function)new Function<HttpClientBuilder, Void>(){

                    @Nullable
                    public Void apply(@Nullable HttpClientBuilder input) {
                        Lib.net.setupProxy(Harvester.this.context, input, requestHost);
                        return null;
                    }
                });
                if (this.log.isDebugEnabled()) {
                    this.log.debug("   Get " + httpResponse.getStatusCode());
                }
                if (httpResponse.getStatusCode() == HttpStatus.OK) {
                    try (OutputStream fo = Files.newOutputStream(file, new OpenOption[0]);
                         InputStream in = httpResponse.getBody();){
                        BinaryFile.copy((InputStream)in, (OutputStream)fo);
                        break block33;
                    }
                }
                this.log.info(" Http error connecting");
                Path path = null;
                return path;
            }
            catch (IOException ioe) {
                this.log.info(" Unable to connect to '" + req.toString() + "'");
                this.log.info(ioe.getMessage());
                Path path = null;
                return path;
            }
            finally {
                req.releaseConnection();
            }
        }
        return file;
    }

    private String getBaseUrl(String url) {
        if (url.endsWith("?")) {
            return url;
        }
        if (url.contains("?")) {
            return url + "&";
        }
        return url + "?";
    }

    @Override
    public List<HarvestError> getErrors() {
        return null;
    }

    private static class WxSLayerRegistry {
        public String uuid;
        public String id;
        public String name;
        public Double minx = -180.0;
        public Double miny = -90.0;
        public Double maxx = 180.0;
        public Double maxy = 90.0;

        private WxSLayerRegistry() {
        }
    }
}

