/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.a2j.codec.util;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jzkit.a2j.codec.util.OIDRegister;
import org.jzkit.a2j.codec.util.OIDRegisterEntry;

public class OIDRegConfigurator {
    private static Logger log = Logger.getLogger(OIDRegConfigurator.class.getName());

    public static void load(OIDRegister reg, String config_file_name) {
        InputStream is = null;
        Object defaults_is = null;
        Properties p = null;
        try {
            is = OIDRegConfigurator.class.getResourceAsStream(config_file_name);
            p = new Properties();
            if (is != null) {
                p.load(is);
            }
            Enumeration<Object> en = p.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                try {
                    String oid_name = key.substring(key.indexOf(46), key.length());
                    if (!key.startsWith("oid")) continue;
                    String oid_string = p.getProperty("oid" + oid_name);
                    String entry_name = p.getProperty("name" + oid_name);
                    String codec_name = p.getProperty("codec" + oid_name);
                    Object the_codec = null;
                    try {
                        if (codec_name != null) {
                            Class<?> codec_class = Class.forName(codec_name);
                            Method get_codec_method = codec_class.getMethod("getCodec", null);
                            the_codec = get_codec_method.invoke(null, null);
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        log.fine("Unable to find codec class : " + codec_name);
                    }
                    reg.register_oid(new OIDRegisterEntry(oid_name.substring(1, oid_name.length()), oid_string, entry_name, the_codec));
                }
                catch (StringIndexOutOfBoundsException sbe) {
                    log.log(Level.WARNING, "Problem loading register", sbe);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Problem loading register", e);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem loading register", e);
        }
    }
}

