/*
 * Decompiled with CFR 0.152.
 */
package yaml.parser;

public final class YamlCharacter {
    public static final int PRINTABLE = 1;
    public static final int WORD = 2;
    public static final int LINE = 3;
    public static final int LINESP = 4;
    public static final int SPACE = 5;
    public static final int LINEBREAK = 6;
    public static final int DIGIT = 7;
    public static final int INDENT = 8;
    public static final int EOF = -1;

    public static boolean is(char c, int n) {
        switch (n) {
            case 1: {
                return YamlCharacter.isPrintableChar(c);
            }
            case 2: {
                return YamlCharacter.isWordChar(c);
            }
            case 3: {
                return YamlCharacter.isLineChar(c);
            }
            case 4: {
                return YamlCharacter.isLineSpChar(c);
            }
            case 5: {
                return YamlCharacter.isSpaceChar(c);
            }
            case 6: {
                return YamlCharacter.isLineBreakChar(c);
            }
            case 7: {
                return Character.isDigit(c);
            }
            case 8: {
                return c == ' ';
            }
        }
        return false;
    }

    public static boolean is(int n, int n2) {
        if (n == -1) {
            return false;
        }
        char c = (char)n;
        switch (n2) {
            case 1: {
                return YamlCharacter.isPrintableChar(c);
            }
            case 2: {
                return YamlCharacter.isWordChar(c);
            }
            case 3: {
                return YamlCharacter.isLineChar(c);
            }
            case 4: {
                return YamlCharacter.isLineSpChar(c);
            }
            case 5: {
                return YamlCharacter.isSpaceChar(c);
            }
            case 6: {
                return YamlCharacter.isLineBreakChar(c);
            }
            case 7: {
                return Character.isDigit(c);
            }
            case 8: {
                return c == ' ';
            }
        }
        return false;
    }

    public static boolean isPrintableChar(char c) {
        if (c >= ' ' && c <= '~') {
            return true;
        }
        if (c == '\t' || c == '\n' || c == '\r' || c == '\u0085') {
            return true;
        }
        if (c >= '\u00a0' && c <= '\ud7ff') {
            return true;
        }
        return c >= '\ue000' && c <= '\ufffd';
    }

    public static boolean isLineChar(char c) {
        if (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\u0085') {
            return false;
        }
        return YamlCharacter.isPrintableChar(c);
    }

    public static boolean isLineSpChar(char c) {
        if (c == '\n' || c == '\r' || c == '\u0085') {
            return false;
        }
        return YamlCharacter.isPrintableChar(c);
    }

    public static boolean isWordChar(char c) {
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        return c == '-';
    }

    public static boolean isSpaceChar(char c) {
        return c == '\t' || c == ' ';
    }

    public static boolean isLineBreakChar(char c) {
        return c == '\n' || c == '\r' || c == '\u0085' || c == '\u2028' || c == '\u2029';
    }

    public static boolean isIndicator(char c) {
        String string = "-:[]{},?*&!|#@%^'\"";
        return string.indexOf(c) != -1;
    }

    public static boolean isIndicatorSpace(char c) {
        String string = ":-";
        return string.indexOf(c) != -1;
    }

    public static boolean isIndicatorInline(char c) {
        String string = "[]{},";
        return string.indexOf(c) != -1;
    }

    public static boolean isIndicatorNonSpace(char c) {
        String string = "?*&!]|#@%^\"'";
        return string.indexOf(c) != -1;
    }

    public static boolean isIndicatorSimple(char c) {
        String string = ":[]{},";
        return string.indexOf(c) != -1;
    }

    public static boolean isLooseIndicatorSimple(char c) {
        String string = "[]{},";
        return string.indexOf(c) != -1;
    }
}

