/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.capability;

import org.geotools.filter.capability.ArithmeticOperatorsImpl;
import org.geotools.filter.capability.ComparisonOperatorsImpl;
import org.opengis.filter.capability.ArithmeticOperators;
import org.opengis.filter.capability.ComparisonOperators;
import org.opengis.filter.capability.ScalarCapabilities;

public class ScalarCapabilitiesImpl
implements ScalarCapabilities {
    ArithmeticOperatorsImpl arithmeticOperators;
    ComparisonOperatorsImpl comparisonOperators;
    boolean logicalOperators;

    public ScalarCapabilitiesImpl() {
        this.arithmeticOperators = new ArithmeticOperatorsImpl();
        this.comparisonOperators = new ComparisonOperatorsImpl();
        this.logicalOperators = false;
    }

    public ScalarCapabilitiesImpl(ComparisonOperators comparisonOperators, ArithmeticOperators arithmeticOperators, boolean logicalOperators) {
        this.arithmeticOperators = ScalarCapabilitiesImpl.toArithmeticOperatorsImpl(arithmeticOperators);
        this.comparisonOperators = ScalarCapabilitiesImpl.toComparisonOperatorsImpl(comparisonOperators);
        this.logicalOperators = logicalOperators;
    }

    public ScalarCapabilitiesImpl(ScalarCapabilities copy) {
        this.arithmeticOperators = copy.getArithmeticOperators() == null ? new ArithmeticOperatorsImpl() : new ArithmeticOperatorsImpl(copy.getArithmeticOperators());
        this.comparisonOperators = copy.getComparisonOperators() == null ? new ComparisonOperatorsImpl() : new ComparisonOperatorsImpl(copy.getComparisonOperators());
        this.logicalOperators = copy.hasLogicalOperators();
    }

    public void setArithmeticOperators(ArithmeticOperatorsImpl arithmeticOperators) {
        this.arithmeticOperators = arithmeticOperators;
    }

    public ArithmeticOperatorsImpl getArithmeticOperators() {
        return this.arithmeticOperators;
    }

    public void setComparisonOperators(ComparisonOperatorsImpl comparisonOperators) {
        this.comparisonOperators = comparisonOperators;
    }

    public ComparisonOperatorsImpl getComparisonOperators() {
        return this.comparisonOperators;
    }

    public void setLogicalOperators(boolean logicalOperators) {
        this.logicalOperators = logicalOperators;
    }

    public boolean hasLogicalOperators() {
        return this.logicalOperators;
    }

    public static ComparisonOperatorsImpl toComparisonOperatorsImpl(ComparisonOperators comparisonOperators) {
        if (comparisonOperators == null) {
            return new ComparisonOperatorsImpl();
        }
        if (comparisonOperators instanceof ComparisonOperatorsImpl) {
            return (ComparisonOperatorsImpl)comparisonOperators;
        }
        return new ComparisonOperatorsImpl(comparisonOperators);
    }

    private static ArithmeticOperatorsImpl toArithmeticOperatorsImpl(ArithmeticOperators arithmeticOperators) {
        if (arithmeticOperators == null) {
            return new ArithmeticOperatorsImpl();
        }
        if (arithmeticOperators instanceof ArithmeticOperatorsImpl) {
            return (ArithmeticOperatorsImpl)arithmeticOperators;
        }
        return new ArithmeticOperatorsImpl(arithmeticOperators);
    }

    public void addAll(ScalarCapabilities copy) {
        if (copy == null) {
            return;
        }
        if (copy.getArithmeticOperators() != null) {
            this.arithmeticOperators.addAll(copy.getArithmeticOperators());
        }
        if (copy.getComparisonOperators() != null) {
            this.comparisonOperators.addAll(copy.getComparisonOperators());
        }
        if (copy.hasLogicalOperators()) {
            this.logicalOperators = true;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arithmeticOperators == null ? 0 : this.arithmeticOperators.hashCode());
        result = 31 * result + (this.comparisonOperators == null ? 0 : this.comparisonOperators.hashCode());
        result = 31 * result + (this.logicalOperators ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScalarCapabilitiesImpl other = (ScalarCapabilitiesImpl)obj;
        if (this.arithmeticOperators == null ? other.arithmeticOperators != null : !this.arithmeticOperators.equals(other.arithmeticOperators)) {
            return false;
        }
        if (this.comparisonOperators == null ? other.comparisonOperators != null : !this.comparisonOperators.equals(other.comparisonOperators)) {
            return false;
        }
        return this.logicalOperators == other.logicalOperators;
    }
}

