/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

class ProcessTweaks
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final boolean stripTweaks;
    private final SortedMap<String, Node> compilerDefaultValueOverrides;
    private static final CharMatcher ID_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.anyOf((CharSequence)"0123456789_."));
    static final DiagnosticType UNKNOWN_TWEAK_WARNING = DiagnosticType.warning("JSC_UNKNOWN_TWEAK_WARNING", "no tweak registered with ID {0}");
    static final DiagnosticType TWEAK_MULTIPLY_REGISTERED_ERROR = DiagnosticType.error("JSC_TWEAK_MULTIPLY_REGISTERED_ERROR", "Tweak {0} has already been registered.");
    static final DiagnosticType NON_LITERAL_TWEAK_ID_ERROR = DiagnosticType.error("JSC_NON_LITERAL_TWEAK_ID_ERROR", "tweak ID must be a string literal");
    static final DiagnosticType INVALID_TWEAK_DEFAULT_VALUE_WARNING = DiagnosticType.warning("JSC_INVALID_TWEAK_DEFAULT_VALUE_WARNING", "tweak {0} registered with {1} must have a default value that is a literal of type {2}");
    static final DiagnosticType NON_GLOBAL_TWEAK_INIT_ERROR = DiagnosticType.error("JSC_NON_GLOBAL_TWEAK_INIT_ERROR", "tweak declaration {0} must occur in the global scope");
    static final DiagnosticType TWEAK_OVERRIDE_AFTER_REGISTERED_ERROR = DiagnosticType.error("JSC_TWEAK_OVERRIDE_AFTER_REGISTERED_ERROR", "Cannot override the default value of tweak {0} after it has been registered");
    static final DiagnosticType TWEAK_WRONG_GETTER_TYPE_WARNING = DiagnosticType.warning("JSC_TWEAK_WRONG_GETTER_TYPE_WARNING", "tweak getter function {0} used for tweak registered using {1}");
    static final DiagnosticType INVALID_TWEAK_ID_ERROR = DiagnosticType.error("JSC_INVALID_TWEAK_ID_ERROR", "tweak ID contains illegal characters. Only letters, numbers, _ and . are allowed");
    private static final Map<String, TweakFunction> TWEAK_FUNCTIONS_MAP = new HashMap<String, TweakFunction>();

    ProcessTweaks(AbstractCompiler compiler, boolean stripTweaks, Map<String, Node> compilerDefaultValueOverrides) {
        this.compiler = compiler;
        this.stripTweaks = stripTweaks;
        this.compilerDefaultValueOverrides = new TreeMap<String, Node>();
        this.compilerDefaultValueOverrides.putAll(compilerDefaultValueOverrides);
    }

    @Override
    public void process(Node externs, Node root) {
        CollectTweaksResult result = this.collectTweaks(root);
        this.applyCompilerDefaultValueOverrides(result.tweakInfos);
        boolean changed = false;
        if (this.stripTweaks) {
            changed = this.stripAllCalls(result.tweakInfos);
        } else if (!this.compilerDefaultValueOverrides.isEmpty()) {
            changed = this.replaceGetCompilerOverridesCalls(result.getOverridesCalls);
        }
        if (changed) {
            this.compiler.reportCodeChange();
        }
    }

    private boolean replaceGetCompilerOverridesCalls(List<TweakFunctionCall> calls) {
        for (TweakFunctionCall call : calls) {
            Node callNode = call.callNode;
            Node objNode = this.createCompilerDefaultValueOverridesVarNode(callNode);
            callNode.getParent().replaceChild(callNode, objNode);
        }
        return !calls.isEmpty();
    }

    private boolean stripAllCalls(Map<String, TweakInfo> tweakInfos) {
        for (TweakInfo tweakInfo : tweakInfos.values()) {
            boolean isRegistered = tweakInfo.isRegistered();
            for (TweakFunctionCall functionCall : tweakInfo.functionCalls) {
                Node callNode = functionCall.callNode;
                Node parent = callNode.getParent();
                if (functionCall.tweakFunc.isGetterFunction()) {
                    Node newValue;
                    if (isRegistered) {
                        newValue = tweakInfo.getDefaultValueNode().cloneNode();
                    } else {
                        TweakFunction registerFunction = functionCall.tweakFunc.registerFunction;
                        newValue = registerFunction.createDefaultValueNode();
                    }
                    parent.replaceChild(callNode, newValue);
                    continue;
                }
                Node voidZeroNode = IR.voidNode(IR.number(0.0).srcref(callNode)).srcref(callNode);
                parent.replaceChild(callNode, voidZeroNode);
            }
        }
        return !tweakInfos.isEmpty();
    }

    private Node createCompilerDefaultValueOverridesVarNode(Node sourceInformationNode) {
        Node objNode = IR.objectlit(new Node[0]).srcref(sourceInformationNode);
        for (Map.Entry<String, Node> entry : this.compilerDefaultValueOverrides.entrySet()) {
            Node objKeyNode = IR.stringKey(entry.getKey()).copyInformationFrom(sourceInformationNode);
            Node objValueNode = entry.getValue().cloneNode().copyInformationFrom(sourceInformationNode);
            objKeyNode.addChildToBack(objValueNode);
            objNode.addChildToBack(objKeyNode);
        }
        return objNode;
    }

    private void applyCompilerDefaultValueOverrides(Map<String, TweakInfo> tweakInfos) {
        for (Map.Entry<String, Node> entry : this.compilerDefaultValueOverrides.entrySet()) {
            String tweakId = entry.getKey();
            TweakInfo tweakInfo = tweakInfos.get(tweakId);
            if (tweakInfo == null) {
                this.compiler.report(JSError.make(UNKNOWN_TWEAK_WARNING, tweakId));
                continue;
            }
            TweakFunction registerFunc = tweakInfo.registerCall.tweakFunc;
            Node value = entry.getValue();
            if (!registerFunc.isValidNodeType(value.getType())) {
                this.compiler.report(JSError.make(INVALID_TWEAK_DEFAULT_VALUE_WARNING, tweakId, registerFunc.getName(), registerFunc.getExpectedTypeName()));
                continue;
            }
            tweakInfo.defaultValueNode = value;
        }
    }

    private CollectTweaksResult collectTweaks(Node root) {
        CollectTweaks pass = new CollectTweaks();
        NodeTraversal.traverse(this.compiler, root, pass);
        Map<String, TweakInfo> tweakInfos = pass.allTweaks;
        for (TweakInfo tweakInfo : tweakInfos.values()) {
            tweakInfo.emitAllWarnings();
        }
        return new CollectTweaksResult(tweakInfos, pass.getOverridesCalls);
    }

    static {
        for (TweakFunction func : TweakFunction.values()) {
            TWEAK_FUNCTIONS_MAP.put(func.getName(), func);
        }
    }

    private final class TweakInfo {
        final String tweakId;
        final List<TweakFunctionCall> functionCalls;
        TweakFunctionCall registerCall;
        Node defaultValueNode;

        TweakInfo(String tweakId) {
            this.tweakId = tweakId;
            this.functionCalls = new ArrayList<TweakFunctionCall>();
        }

        void emitAllWarnings() {
            if (this.isRegistered()) {
                this.emitAllTypeWarnings();
            } else {
                this.emitUnknownTweakErrors();
            }
        }

        void emitAllTypeWarnings() {
            for (TweakFunctionCall call : this.functionCalls) {
                Node valueNode = call.valueNode;
                TweakFunction tweakFunc = call.tweakFunc;
                TweakFunction registerFunc = this.registerCall.tweakFunc;
                if (valueNode != null) {
                    if (registerFunc.isValidNodeType(valueNode.getType())) continue;
                    ProcessTweaks.this.compiler.report(JSError.make(valueNode, INVALID_TWEAK_DEFAULT_VALUE_WARNING, this.tweakId, registerFunc.getName(), registerFunc.getExpectedTypeName()));
                    continue;
                }
                if (!tweakFunc.isGetterFunction() || tweakFunc.isCorrectRegisterFunction(registerFunc)) continue;
                ProcessTweaks.this.compiler.report(JSError.make(call.callNode, TWEAK_WRONG_GETTER_TYPE_WARNING, tweakFunc.getName(), registerFunc.getName()));
            }
        }

        void emitUnknownTweakErrors() {
            for (TweakFunctionCall call : this.functionCalls) {
                ProcessTweaks.this.compiler.report(JSError.make(call.getIdNode(), UNKNOWN_TWEAK_WARNING, this.tweakId));
            }
        }

        void addRegisterCall(String sourceName, TweakFunction tweakFunc, Node callNode, Node defaultValueNode) {
            this.registerCall = new TweakFunctionCall(tweakFunc, callNode, defaultValueNode);
            this.functionCalls.add(this.registerCall);
        }

        void addOverrideDefaultValueCall(String sourceName, TweakFunction tweakFunc, Node callNode, Node defaultValueNode) {
            this.functionCalls.add(new TweakFunctionCall(tweakFunc, callNode, defaultValueNode));
            this.defaultValueNode = defaultValueNode;
        }

        void addGetterCall(String sourceName, TweakFunction tweakFunc, Node callNode) {
            this.functionCalls.add(new TweakFunctionCall(tweakFunc, callNode));
        }

        boolean isRegistered() {
            return this.registerCall != null;
        }

        Node getDefaultValueNode() {
            Preconditions.checkState((boolean)this.isRegistered());
            if (this.defaultValueNode != null) {
                return this.defaultValueNode;
            }
            if (this.registerCall.valueNode != null) {
                return this.registerCall.valueNode;
            }
            return this.registerCall.tweakFunc.createDefaultValueNode();
        }
    }

    private static final class TweakFunctionCall {
        final TweakFunction tweakFunc;
        final Node callNode;
        final Node valueNode;

        TweakFunctionCall(TweakFunction tweakFunc, Node callNode) {
            this(tweakFunc, callNode, null);
        }

        TweakFunctionCall(TweakFunction tweakFunc, Node callNode, Node valueNode) {
            this.callNode = callNode;
            this.tweakFunc = tweakFunc;
            this.valueNode = valueNode;
        }

        Node getIdNode() {
            return this.callNode.getFirstChild().getNext();
        }
    }

    private final class CollectTweaks
    extends NodeTraversal.AbstractPostOrderCallback {
        final Map<String, TweakInfo> allTweaks = new HashMap<String, TweakInfo>();
        final List<TweakFunctionCall> getOverridesCalls = new ArrayList<TweakFunctionCall>();

        private CollectTweaks() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isCall()) {
                return;
            }
            String callName = n.getFirstChild().getQualifiedName();
            TweakFunction tweakFunc = (TweakFunction)((Object)TWEAK_FUNCTIONS_MAP.get(callName));
            if (tweakFunc == null) {
                return;
            }
            if (tweakFunc == TweakFunction.GET_COMPILER_OVERRIDES) {
                this.getOverridesCalls.add(new TweakFunctionCall(tweakFunc, n));
                return;
            }
            Node tweakIdNode = n.getFirstChild().getNext();
            if (!tweakIdNode.isString()) {
                ProcessTweaks.this.compiler.report(t.makeError(tweakIdNode, NON_LITERAL_TWEAK_ID_ERROR, new String[0]));
                return;
            }
            String tweakId = tweakIdNode.getString();
            TweakInfo tweakInfo = this.allTweaks.get(tweakId);
            if (tweakInfo == null) {
                tweakInfo = new TweakInfo(tweakId);
                this.allTweaks.put(tweakId, tweakInfo);
            }
            switch (tweakFunc) {
                case REGISTER_BOOLEAN: 
                case REGISTER_NUMBER: 
                case REGISTER_STRING: {
                    if (!ID_MATCHER.matchesAllOf((CharSequence)tweakId)) {
                        ProcessTweaks.this.compiler.report(t.makeError(tweakIdNode, INVALID_TWEAK_ID_ERROR, new String[0]));
                    }
                    if (!t.inGlobalScope()) {
                        ProcessTweaks.this.compiler.report(t.makeError(n, NON_GLOBAL_TWEAK_INIT_ERROR, tweakId));
                        break;
                    }
                    if (tweakInfo.isRegistered()) {
                        ProcessTweaks.this.compiler.report(t.makeError(n, TWEAK_MULTIPLY_REGISTERED_ERROR, tweakId));
                        break;
                    }
                    Node tweakDefaultValueNode = tweakIdNode.getNext().getNext();
                    tweakInfo.addRegisterCall(t.getSourceName(), tweakFunc, n, tweakDefaultValueNode);
                    break;
                }
                case OVERRIDE_DEFAULT_VALUE: {
                    if (!t.inGlobalScope()) {
                        ProcessTweaks.this.compiler.report(t.makeError(n, NON_GLOBAL_TWEAK_INIT_ERROR, tweakId));
                        break;
                    }
                    if (tweakInfo.isRegistered()) {
                        ProcessTweaks.this.compiler.report(t.makeError(n, TWEAK_OVERRIDE_AFTER_REGISTERED_ERROR, tweakId));
                        break;
                    }
                    Node tweakDefaultValueNode = tweakIdNode.getNext();
                    tweakInfo.addOverrideDefaultValueCall(t.getSourceName(), tweakFunc, n, tweakDefaultValueNode);
                    break;
                }
                case GET_BOOLEAN: 
                case GET_NUMBER: 
                case GET_STRING: {
                    tweakInfo.addGetterCall(t.getSourceName(), tweakFunc, n);
                }
            }
        }
    }

    private static final class CollectTweaksResult {
        final Map<String, TweakInfo> tweakInfos;
        final List<TweakFunctionCall> getOverridesCalls;

        CollectTweaksResult(Map<String, TweakInfo> tweakInfos, List<TweakFunctionCall> getOverridesCalls) {
            this.tweakInfos = tweakInfos;
            this.getOverridesCalls = getOverridesCalls;
        }
    }

    private static enum TweakFunction {
        REGISTER_BOOLEAN("goog.tweak.registerBoolean", "boolean", 44, 43),
        REGISTER_NUMBER("goog.tweak.registerNumber", "number", 39),
        REGISTER_STRING("goog.tweak.registerString", "string", 40),
        OVERRIDE_DEFAULT_VALUE("goog.tweak.overrideDefaultValue"),
        GET_COMPILER_OVERRIDES("goog.tweak.getCompilerOverrides_"),
        GET_BOOLEAN("goog.tweak.getBoolean", REGISTER_BOOLEAN),
        GET_NUMBER("goog.tweak.getNumber", REGISTER_NUMBER),
        GET_STRING("goog.tweak.getString", REGISTER_STRING);

        final String name;
        final String expectedTypeName;
        final int validNodeTypeA;
        final int validNodeTypeB;
        final TweakFunction registerFunction;

        private TweakFunction(String name) {
            this(name, null, -1, -1, null);
        }

        private TweakFunction(String name, String expectedTypeName, int validNodeTypeA) {
            this(name, expectedTypeName, validNodeTypeA, -1, null);
        }

        private TweakFunction(String name, String expectedTypeName, int validNodeTypeA, int validNodeTypeB) {
            this(name, expectedTypeName, validNodeTypeA, validNodeTypeB, null);
        }

        private TweakFunction(String name, TweakFunction registerFunction) {
            this(name, null, -1, -1, registerFunction);
        }

        private TweakFunction(String name, String expectedTypeName, int validNodeTypeA, int validNodeTypeB, TweakFunction registerFunction) {
            this.name = name;
            this.expectedTypeName = expectedTypeName;
            this.validNodeTypeA = validNodeTypeA;
            this.validNodeTypeB = validNodeTypeB;
            this.registerFunction = registerFunction;
        }

        boolean isValidNodeType(int type) {
            return type == this.validNodeTypeA || type == this.validNodeTypeB;
        }

        boolean isCorrectRegisterFunction(TweakFunction registerFunction) {
            Preconditions.checkNotNull((Object)((Object)registerFunction));
            return this.registerFunction == registerFunction;
        }

        boolean isGetterFunction() {
            return this.registerFunction != null;
        }

        String getName() {
            return this.name;
        }

        String getExpectedTypeName() {
            return this.expectedTypeName;
        }

        Node createDefaultValueNode() {
            switch (this) {
                case REGISTER_BOOLEAN: {
                    return IR.falseNode();
                }
                case REGISTER_NUMBER: {
                    return IR.number(0.0);
                }
                case REGISTER_STRING: {
                    return IR.string("");
                }
            }
            throw new IllegalStateException();
        }
    }
}

