/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

abstract class MethodCompilerPass
implements CompilerPass {
    final Set<String> externMethods = new HashSet<String>();
    final Set<String> externMethodsWithoutSignatures = new HashSet<String>();
    final Set<String> nonMethodProperties = new HashSet<String>();
    final Multimap<String, Node> methodDefinitions = LinkedHashMultimap.create();
    final AbstractCompiler compiler;

    MethodCompilerPass(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.externMethods.clear();
        this.externMethodsWithoutSignatures.clear();
        this.getSignatureStore().reset();
        this.methodDefinitions.clear();
        if (externs != null) {
            NodeTraversal.traverse(this.compiler, externs, new GetExternMethods());
        }
        NodeTraversal.traverseRoots(this.compiler, new GatherSignatures(), externs, root);
        NodeTraversal.traverseRoots(this.compiler, this.getActingCallback(), externs, root);
    }

    abstract NodeTraversal.Callback getActingCallback();

    abstract SignatureStore getSignatureStore();

    private void addPossibleSignature(String name, Node node, NodeTraversal t) {
        if (node.isFunction()) {
            this.addSignature(name, node, t.getSourceName());
        } else {
            this.nonMethodProperties.add(name);
        }
    }

    private void addSignature(String name, Node function, String fnSourceName) {
        if (this.externMethodsWithoutSignatures.contains(name)) {
            return;
        }
        this.getSignatureStore().addSignature(name, function, fnSourceName);
        this.methodDefinitions.put((Object)name, (Object)function);
    }

    private class GatherSignatures
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherSignatures() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 33: 
                case 35: {
                    Node dest = n.getFirstChild().getNext();
                    if (!dest.isString()) break;
                    if (dest.getString().equals("prototype")) {
                        this.processPrototypeParent(t, parent);
                        break;
                    }
                    if (!parent.isAssign() || parent.getFirstChild() != n) break;
                    MethodCompilerPass.this.addPossibleSignature(dest.getString(), n.getNext(), t);
                    break;
                }
                case 64: {
                    block8: for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
                        switch (key.getType()) {
                            case 154: {
                                MethodCompilerPass.this.addPossibleSignature(key.getString(), key.getFirstChild(), t);
                                continue block8;
                            }
                            case 147: 
                            case 148: {
                                MethodCompilerPass.this.nonMethodProperties.add(key.getString());
                                continue block8;
                            }
                            default: {
                                throw new IllegalStateException("unexpect OBJECTLIT key: " + key);
                            }
                        }
                    }
                    break;
                }
            }
        }

        private void processPrototypeParent(NodeTraversal t, Node n) {
            switch (n.getType()) {
                case 33: 
                case 35: {
                    Node dest = n.getFirstChild().getNext();
                    Node parent = n.getParent().getParent();
                    if (!dest.isString() || !parent.isAssign()) break;
                    Node assignee = parent.getFirstChild().getNext();
                    MethodCompilerPass.this.addPossibleSignature(dest.getString(), assignee, t);
                }
            }
        }
    }

    private class GetExternMethods
    extends NodeTraversal.AbstractPostOrderCallback {
        private GetExternMethods() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 33: 
                case 35: {
                    Node dest = n.getFirstChild().getNext();
                    if (!dest.isString()) {
                        return;
                    }
                    String name = dest.getString();
                    if (parent.isAssign() && parent.getFirstChild() == n && n.getNext().isFunction()) {
                        MethodCompilerPass.this.addSignature(name, n.getNext(), t.getSourceName());
                    } else {
                        MethodCompilerPass.this.getSignatureStore().removeSignature(name);
                        MethodCompilerPass.this.externMethodsWithoutSignatures.add(name);
                    }
                    MethodCompilerPass.this.externMethods.add(name);
                    break;
                }
                case 64: {
                    for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
                        Node value = key.getFirstChild();
                        String name = key.getString();
                        if (key.isStringKey() && value.isFunction()) {
                            MethodCompilerPass.this.addSignature(name, value, t.getSourceName());
                        } else {
                            MethodCompilerPass.this.getSignatureStore().removeSignature(name);
                            MethodCompilerPass.this.externMethodsWithoutSignatures.add(name);
                        }
                        MethodCompilerPass.this.externMethods.add(name);
                    }
                    break;
                }
            }
        }
    }

    static interface SignatureStore {
        public void reset();

        public void addSignature(String var1, Node var2, String var3);

        public void removeSignature(String var1);
    }
}

