/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.sql;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.geotools.metadata.sql.MetadataException;
import org.geotools.metadata.sql.MetadataSource;

final class MetadataEntity
implements InvocationHandler {
    private final String identifier;
    private final MetadataSource source;

    public MetadataEntity(String identifier, MetadataSource source) {
        this.identifier = identifier;
        this.source = source;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        Class<?> type = method.getDeclaringClass();
        if (type.getName().startsWith(this.source.metadataPackage)) {
            if (args != null && args.length != 0) {
                throw new MetadataException("Unexpected argument.");
            }
            try {
                return this.source.getValue(type, method, this.identifier);
            }
            catch (SQLException e) {
                throw new MetadataException("Failed to query the database.", e);
            }
        }
        try {
            return method.invoke((Object)this, args);
        }
        catch (IllegalAccessException e) {
            throw new MetadataException("Illegal method call.", e);
        }
        catch (InvocationTargetException e) {
            throw new MetadataException("Illegal method call.", e);
        }
    }
}

