/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataDataInfo;
import org.fao.geonet.domain.MetadataHarvestInfo;
import org.fao.geonet.domain.MetadataSourceInfo;
import org.fao.geonet.utils.Xml;
import org.hibernate.annotations.Type;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.springframework.util.Assert;

@MappedSuperclass
public abstract class AbstractMetadata
extends GeonetEntity {
    public static final String ID_SEQ_NAME = "metadata_id_seq";
    public static final String METADATA_CATEG_JOIN_TABLE_CATEGORY_ID = "categoryId";
    public static final String ID_COLUMN_NAME = "id";
    private int _id;
    private String _uuid;
    private String _data;
    private MetadataDataInfo _dataInfo = new MetadataDataInfo();
    private MetadataSourceInfo _sourceInfo = new MetadataSourceInfo();
    private MetadataHarvestInfo _harvestInfo = new MetadataHarvestInfo();
    @Transient
    protected Set<MetadataCategory> metadataCategories = new HashSet<MetadataCategory>();

    @Id
    @SequenceGenerator(name="metadata_id_seq", initialValue=100, allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="metadata_id_seq")
    @Column(name="id", nullable=false)
    public int getId() {
        return this._id;
    }

    public AbstractMetadata setId(int _id) {
        this._id = _id;
        return this;
    }

    @Column(nullable=false, unique=true)
    @Nonnull
    public String getUuid() {
        return this._uuid;
    }

    @Nonnull
    public AbstractMetadata setUuid(@Nonnull String uuid) {
        Assert.isTrue((uuid != null ? 1 : 0) != 0, (String)"Cannot have null uuid");
        this._uuid = uuid;
        return this;
    }

    @Column(nullable=false)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    public String getData() {
        return this._data;
    }

    public AbstractMetadata setData(String data) {
        this._data = data;
        return this;
    }

    public AbstractMetadata setDataAndFixCR(Element xml) {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        String data = outputter.outputString(this.fixCR(xml));
        this.setData(data);
        return this;
    }

    private Element fixCR(Element xml) {
        List list = xml.getChildren();
        if (list.size() == 0) {
            String text = xml.getText();
            xml.setText(AbstractMetadata.replaceString(text, "\r\n", "\n"));
        } else {
            for (Object o : list) {
                this.fixCR((Element)o);
            }
        }
        return xml;
    }

    @Transient
    public Element getXmlData(boolean validate) throws IOException, JDOMException {
        return Xml.loadString((String)this.getData(), (boolean)validate);
    }

    private static String replaceString(String initialString, String pattern, String replacement) {
        int i;
        StringBuilder result = new StringBuilder();
        String remainingString = initialString;
        while ((i = remainingString.indexOf(pattern)) != -1) {
            result.append(remainingString.substring(0, i));
            result.append(replacement);
            remainingString = remainingString.substring(i + pattern.length());
        }
        result.append(remainingString);
        return result.toString();
    }

    @Embedded
    public MetadataDataInfo getDataInfo() {
        return this._dataInfo;
    }

    public void setDataInfo(MetadataDataInfo dataInfo) {
        this._dataInfo = dataInfo;
    }

    @Embedded
    public MetadataSourceInfo getSourceInfo() {
        return this._sourceInfo;
    }

    public void setSourceInfo(MetadataSourceInfo sourceInfo) {
        this._sourceInfo = sourceInfo;
    }

    @Embedded
    public MetadataHarvestInfo getHarvestInfo() {
        return this._harvestInfo;
    }

    public void setHarvestInfo(MetadataHarvestInfo harvestInfo) {
        this._harvestInfo = harvestInfo;
    }

    @Transient
    public Set<MetadataCategory> getCategories() {
        return this.metadataCategories;
    }

    public String toString() {
        int maxLen = 3;
        return this.getClass().getSimpleName() + " [_id=" + this._id + ", " + (this._uuid != null ? "_uuid=" + this._uuid + ", " : "") + (this._dataInfo != null ? "_dataInfo=" + this._dataInfo + ", " : "") + (this._sourceInfo != null ? "_sourceInfo=" + this._sourceInfo + ", " : "") + (this._harvestInfo != null ? "_harvestInfo=" + this._harvestInfo + ", " : "") + (this.metadataCategories != null ? "metadataCategories=" + this.toString(this.metadataCategories, 3) : "") + "]";
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    @Transient
    public AbstractMetadata clone() {
        TransientMetadata clone = new TransientMetadata();
        clone.setId(this.getId());
        clone.setUuid(this.getUuid());
        if (this.getDataInfo() != null) {
            clone.setDataInfo(this.getDataInfo().clone());
        }
        if (this.getHarvestInfo() != null) {
            clone.setHarvestInfo(this.getHarvestInfo().clone());
        }
        if (this.getSourceInfo() != null) {
            clone.setSourceInfo(this.getSourceInfo().clone());
        }
        return clone;
    }

    private class TransientMetadata
    extends AbstractMetadata {
        private TransientMetadata() {
        }
    }
}

