/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.fieldvisitor.CustomFieldsVisitor;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.LeafNestedDocuments;
import org.elasticsearch.search.NestedDocuments;
import org.elasticsearch.search.SearchContextSourcePrinter;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.fetch.FetchContext;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.elasticsearch.search.fetch.subphase.InnerHitsPhase;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SourceLookup;
import org.elasticsearch.tasks.TaskCancelledException;

public class FetchPhase {
    private static final Logger LOGGER = LogManager.getLogger(FetchPhase.class);
    private final FetchSubPhase[] fetchSubPhases;

    public FetchPhase(List<FetchSubPhase> fetchSubPhases) {
        this.fetchSubPhases = fetchSubPhases.toArray(new FetchSubPhase[fetchSubPhases.size() + 1]);
        this.fetchSubPhases[fetchSubPhases.size()] = new InnerHitsPhase(this);
    }

    public void execute(SearchContext context) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)new SearchContextSourcePrinter(context));
        }
        if (context.isCancelled()) {
            throw new TaskCancelledException("cancelled");
        }
        if (context.docIdsToLoadSize() == 0) {
            context.fetchResult().hits(new SearchHits(new SearchHit[0], context.queryResult().getTotalHits(), context.queryResult().getMaxScore()));
            return;
        }
        Object[] docs = new DocIdToIndex[context.docIdsToLoadSize()];
        for (int index = 0; index < context.docIdsToLoadSize(); ++index) {
            docs[index] = new DocIdToIndex(context.docIdsToLoad()[index], index);
        }
        Arrays.sort(docs);
        HashMap<String, Set<String>> storedToRequestedFields = new HashMap<String, Set<String>>();
        FieldsVisitor fieldsVisitor = this.createStoredFieldsVisitor(context, storedToRequestedFields);
        FetchContext fetchContext = new FetchContext(context);
        SearchHit[] hits = new SearchHit[context.docIdsToLoadSize()];
        List<FetchSubPhaseProcessor> processors = this.getProcessors(context.shardTarget(), fetchContext);
        NestedDocuments nestedDocuments = context.getSearchExecutionContext().getNestedDocuments();
        int currentReaderIndex = -1;
        LeafReaderContext currentReaderContext = null;
        LeafNestedDocuments leafNestedDocuments = null;
        CheckedBiConsumer fieldReader = null;
        boolean hasSequentialDocs = FetchPhase.hasSequentialDocs((DocIdToIndex[])docs);
        for (int index = 0; index < context.docIdsToLoadSize(); ++index) {
            if (context.isCancelled()) {
                throw new TaskCancelledException("cancelled");
            }
            int docId = ((DocIdToIndex)docs[index]).docId;
            try {
                int readerIndex = ReaderUtil.subIndex((int)docId, (List)context.searcher().getIndexReader().leaves());
                if (currentReaderIndex != readerIndex) {
                    currentReaderContext = (LeafReaderContext)context.searcher().getIndexReader().leaves().get(readerIndex);
                    currentReaderIndex = readerIndex;
                    if (currentReaderContext.reader() instanceof SequentialStoredFieldsLeafReader && hasSequentialDocs && docs.length >= 10) {
                        SequentialStoredFieldsLeafReader lf = (SequentialStoredFieldsLeafReader)currentReaderContext.reader();
                        fieldReader = (arg_0, arg_1) -> ((StoredFieldsReader)lf.getSequentialStoredFieldsReader()).visitDocument(arg_0, arg_1);
                    } else {
                        fieldReader = (arg_0, arg_1) -> ((LeafReader)currentReaderContext.reader()).document(arg_0, arg_1);
                    }
                    for (FetchSubPhaseProcessor processor : processors) {
                        processor.setNextReader(currentReaderContext);
                    }
                    leafNestedDocuments = nestedDocuments.getLeafNestedDocuments(currentReaderContext);
                }
                assert (currentReaderContext != null);
                FetchSubPhase.HitContext hit = this.prepareHitContext(context, leafNestedDocuments, fieldsVisitor, docId, storedToRequestedFields, currentReaderContext, fieldReader);
                for (FetchSubPhaseProcessor processor : processors) {
                    processor.process(hit);
                }
                hits[((DocIdToIndex)docs[index]).index] = hit.hit();
                continue;
            }
            catch (Exception e) {
                throw new FetchPhaseExecutionException(context.shardTarget(), "Error running fetch phase for doc [" + docId + "]", e);
            }
        }
        if (context.isCancelled()) {
            throw new TaskCancelledException("cancelled");
        }
        TotalHits totalHits = context.queryResult().getTotalHits();
        context.fetchResult().hits(new SearchHits(hits, totalHits, context.queryResult().getMaxScore()));
    }

    List<FetchSubPhaseProcessor> getProcessors(SearchShardTarget target, FetchContext context) {
        try {
            ArrayList<FetchSubPhaseProcessor> processors = new ArrayList<FetchSubPhaseProcessor>();
            for (FetchSubPhase fsp : this.fetchSubPhases) {
                FetchSubPhaseProcessor processor = fsp.getProcessor(context);
                if (processor == null) continue;
                processors.add(processor);
            }
            return processors;
        }
        catch (Exception e) {
            throw new FetchPhaseExecutionException(target, "Error building fetch sub-phases", e);
        }
    }

    private FieldsVisitor createStoredFieldsVisitor(SearchContext context, Map<String, Set<String>> storedToRequestedFields) {
        StoredFieldsContext storedFieldsContext = context.storedFieldsContext();
        if (storedFieldsContext == null) {
            if (!context.hasScriptFields() && !context.hasFetchSourceContext()) {
                context.fetchSourceContext(new FetchSourceContext(true));
            }
            boolean loadSource = this.sourceRequired(context);
            return new FieldsVisitor(loadSource);
        }
        if (!storedFieldsContext.fetchFields()) {
            return null;
        }
        for (String fieldNameOrPattern : context.storedFieldsContext().fieldNames()) {
            if (fieldNameOrPattern.equals("_source")) {
                FetchSourceContext fetchSourceContext = context.hasFetchSourceContext() ? context.fetchSourceContext() : FetchSourceContext.FETCH_SOURCE;
                context.fetchSourceContext(new FetchSourceContext(true, fetchSourceContext.includes(), fetchSourceContext.excludes()));
                continue;
            }
            SearchExecutionContext searchExecutionContext = context.getSearchExecutionContext();
            Set<String> fieldNames = searchExecutionContext.getMatchingFieldNames(fieldNameOrPattern);
            for (String fieldName : fieldNames) {
                MappedFieldType fieldType = searchExecutionContext.getFieldType(fieldName);
                String storedField = fieldType.name();
                Set requestedFields = storedToRequestedFields.computeIfAbsent(storedField, key -> new HashSet());
                requestedFields.add(fieldName);
            }
        }
        boolean loadSource = this.sourceRequired(context);
        if (storedToRequestedFields.isEmpty()) {
            return new FieldsVisitor(loadSource);
        }
        return new CustomFieldsVisitor(storedToRequestedFields.keySet(), loadSource);
    }

    private boolean sourceRequired(SearchContext context) {
        return context.sourceRequested() || context.fetchFieldsContext() != null;
    }

    private FetchSubPhase.HitContext prepareHitContext(SearchContext context, LeafNestedDocuments nestedDocuments, FieldsVisitor fieldsVisitor, int docId, Map<String, Set<String>> storedToRequestedFields, LeafReaderContext subReaderContext, CheckedBiConsumer<Integer, FieldsVisitor, IOException> storedFieldReader) throws IOException {
        if (nestedDocuments.advance(docId - subReaderContext.docBase) == null) {
            return this.prepareNonNestedHitContext(context, fieldsVisitor, docId, storedToRequestedFields, subReaderContext, storedFieldReader);
        }
        return this.prepareNestedHitContext(context, docId, nestedDocuments, storedToRequestedFields, subReaderContext, storedFieldReader);
    }

    private FetchSubPhase.HitContext prepareNonNestedHitContext(SearchContext context, FieldsVisitor fieldsVisitor, int docId, Map<String, Set<String>> storedToRequestedFields, LeafReaderContext subReaderContext, CheckedBiConsumer<Integer, FieldsVisitor, IOException> fieldReader) throws IOException {
        SearchHit hit;
        int subDocId = docId - subReaderContext.docBase;
        SearchExecutionContext searchExecutionContext = context.getSearchExecutionContext();
        if (fieldsVisitor == null) {
            SearchHit hit2 = new SearchHit(docId, null, new Text(searchExecutionContext.getType()), null, null);
            return new FetchSubPhase.HitContext(hit2, subReaderContext, subDocId);
        }
        this.loadStoredFields(context.getSearchExecutionContext()::getFieldType, searchExecutionContext.getType(), fieldReader, fieldsVisitor, subDocId);
        Uid uid = fieldsVisitor.uid();
        if (!fieldsVisitor.fields().isEmpty()) {
            HashMap<String, DocumentField> docFields = new HashMap<String, DocumentField>();
            HashMap<String, DocumentField> metaFields = new HashMap<String, DocumentField>();
            FetchPhase.fillDocAndMetaFields(context, fieldsVisitor, storedToRequestedFields, docFields, metaFields);
            hit = new SearchHit(docId, uid.id(), new Text(searchExecutionContext.getType()), docFields, metaFields);
        } else {
            hit = new SearchHit(docId, uid.id(), new Text(searchExecutionContext.getType()), Collections.emptyMap(), Collections.emptyMap());
        }
        FetchSubPhase.HitContext hitContext = new FetchSubPhase.HitContext(hit, subReaderContext, subDocId);
        if (fieldsVisitor.source() != null) {
            hitContext.sourceLookup().setSource(fieldsVisitor.source());
            SourceLookup scriptSourceLookup = context.getSearchExecutionContext().lookup().source();
            scriptSourceLookup.setSegmentAndDocument(subReaderContext, subDocId);
            scriptSourceLookup.setSource(fieldsVisitor.source());
        }
        return hitContext;
    }

    private FetchSubPhase.HitContext prepareNestedHitContext(SearchContext context, int topDocId, LeafNestedDocuments nestedInfo, Map<String, Set<String>> storedToRequestedFields, LeafReaderContext subReaderContext, CheckedBiConsumer<Integer, FieldsVisitor, IOException> storedFieldReader) throws IOException {
        Uid rootId;
        boolean needSource = this.sourceRequired(context) || context.highlight() != null;
        Map<?, ?> rootSourceAsMap = null;
        XContentType rootSourceContentType = null;
        SearchExecutionContext searchExecutionContext = context.getSearchExecutionContext();
        if (context instanceof InnerHitsContext.InnerHitSubContext) {
            InnerHitsContext.InnerHitSubContext innerHitsContext = (InnerHitsContext.InnerHitSubContext)context;
            rootId = innerHitsContext.getRootId();
            if (needSource) {
                SourceLookup rootLookup = innerHitsContext.getRootLookup();
                rootSourceAsMap = rootLookup.source();
                rootSourceContentType = rootLookup.sourceContentType();
            }
        } else {
            FieldsVisitor rootFieldsVisitor = new FieldsVisitor(needSource);
            this.loadStoredFields(searchExecutionContext::getFieldType, searchExecutionContext.getType(), storedFieldReader, rootFieldsVisitor, nestedInfo.rootDoc());
            rootFieldsVisitor.postProcess(searchExecutionContext::getFieldType, searchExecutionContext.getType());
            rootId = rootFieldsVisitor.uid();
            if (needSource) {
                if (rootFieldsVisitor.source() != null) {
                    Tuple<XContentType, Map<String, Object>> tuple = XContentHelper.convertToMap(rootFieldsVisitor.source(), false);
                    rootSourceAsMap = (Map<?, ?>)tuple.v2();
                    rootSourceContentType = (XContentType)tuple.v1();
                } else {
                    rootSourceAsMap = Collections.emptyMap();
                }
            }
        }
        Map<String, DocumentField> docFields = Collections.emptyMap();
        Map<String, DocumentField> metaFields = Collections.emptyMap();
        if (context.hasStoredFields() && !context.storedFieldsContext().fieldNames().isEmpty()) {
            CustomFieldsVisitor nestedFieldsVisitor = new CustomFieldsVisitor(storedToRequestedFields.keySet(), false);
            this.loadStoredFields(searchExecutionContext::getFieldType, searchExecutionContext.getType(), storedFieldReader, nestedFieldsVisitor, nestedInfo.doc());
            if (!nestedFieldsVisitor.fields().isEmpty()) {
                docFields = new HashMap<String, DocumentField>();
                metaFields = new HashMap<String, DocumentField>();
                FetchPhase.fillDocAndMetaFields(context, nestedFieldsVisitor, storedToRequestedFields, docFields, metaFields);
            }
        }
        SearchHit.NestedIdentity nestedIdentity = nestedInfo.nestedIdentity();
        SearchHit hit = new SearchHit(topDocId, rootId.id(), new Text(searchExecutionContext.getType()), nestedIdentity, docFields, metaFields);
        FetchSubPhase.HitContext hitContext = new FetchSubPhase.HitContext(hit, subReaderContext, nestedInfo.doc());
        if (rootSourceAsMap != null && !rootSourceAsMap.isEmpty()) {
            HashMap<String, Object> nestedSourceAsMap;
            HashMap<String, Object> current = nestedSourceAsMap = new HashMap<String, Object>();
            for (SearchHit.NestedIdentity nested = nestedIdentity; nested != null; nested = nested.getChild()) {
                String nestedPath = nested.getField().string();
                current.put(nestedPath, new HashMap());
                List<Map<?, ?>> nestedParsedSource = XContentMapValues.extractNestedSources(nestedPath, rootSourceAsMap);
                if (nestedParsedSource == null) {
                    throw new IllegalStateException("Couldn't find nested source for path " + nestedPath);
                }
                rootSourceAsMap = nestedParsedSource.get(nested.getOffset());
                if (nested.getChild() == null) {
                    current.put(nestedPath, rootSourceAsMap);
                    continue;
                }
                HashMap next = new HashMap();
                current.put(nestedPath, next);
                current = next;
            }
            hitContext.sourceLookup().setSource(nestedSourceAsMap);
            hitContext.sourceLookup().setSourceContentType(rootSourceContentType);
        }
        return hitContext;
    }

    private void loadStoredFields(Function<String, MappedFieldType> fieldTypeLookup, @Nullable String type, CheckedBiConsumer<Integer, FieldsVisitor, IOException> fieldReader, FieldsVisitor fieldVisitor, int docId) throws IOException {
        fieldVisitor.reset();
        fieldReader.accept(docId, fieldVisitor);
        fieldVisitor.postProcess(fieldTypeLookup, type);
    }

    private static void fillDocAndMetaFields(SearchContext context, FieldsVisitor fieldsVisitor, Map<String, Set<String>> storedToRequestedFields, Map<String, DocumentField> docFields, Map<String, DocumentField> metaFields) {
        for (Map.Entry<String, List<Object>> entry : fieldsVisitor.fields().entrySet()) {
            String storedField = entry.getKey();
            List<Object> storedValues = entry.getValue();
            if (storedToRequestedFields.containsKey(storedField)) {
                for (String requestedField : storedToRequestedFields.get(storedField)) {
                    if (context.getSearchExecutionContext().isMetadataField(requestedField)) {
                        metaFields.put(requestedField, new DocumentField(requestedField, storedValues));
                        continue;
                    }
                    docFields.put(requestedField, new DocumentField(requestedField, storedValues));
                }
                continue;
            }
            if (context.getSearchExecutionContext().isMetadataField(storedField)) {
                metaFields.put(storedField, new DocumentField(storedField, storedValues));
                continue;
            }
            docFields.put(storedField, new DocumentField(storedField, storedValues));
        }
    }

    static boolean hasSequentialDocs(DocIdToIndex[] docs) {
        return docs.length > 0 && docs[docs.length - 1].docId - docs[0].docId == docs.length - 1;
    }

    static class DocIdToIndex
    implements Comparable<DocIdToIndex> {
        final int docId;
        final int index;

        DocIdToIndex(int docId, int index) {
            this.docId = docId;
            this.index = index;
        }

        @Override
        public int compareTo(DocIdToIndex o) {
            return Integer.compare(this.docId, o.docId);
        }
    }
}

