/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.SourceType;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.web.DefaultLanguage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@Lazy(value=true)
public class LocaleRedirects {
    private static final String LANG_PARAMETER = "hl";
    private static final String ACCEPT_LANGUAGE_HEADER = "Accept-Language";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String ACCEPT_VALUE = "text/html";
    private static final String REFERER_PARAMETER = "referer";
    private static final String NODE_PARAMETER = "node";
    private static final Set<String> SPECIAL_HEADERS;
    private String _homeRedirectUrl = "catalog.search";
    private String _portalHomeRedirectUrl = "srv/api/sources";
    @Autowired
    DefaultLanguage defaultLanguage;
    @Autowired
    NodeInfo currentNode;
    @Autowired
    SourceRepository sourceRepository;

    @RequestMapping(value={"/"})
    public ModelAndView redirectRootPath(HttpServletRequest request, @CookieValue(value="geonetwork_Preferred_Language_Cookie", required=false) String langCookie, @RequestHeader(value="Accept", required=false) String accept, @RequestParam(value="hl", required=false) String langParam, @RequestHeader(value="Accept-Language", required=false) String langHeader, @RequestParam(value="node", required=false) String portal) throws ResourceNotFoundException {
        String lang = this.lang(langParam, langCookie, langHeader);
        if (this.checkPortalExist(portal, !accept.startsWith(ACCEPT_VALUE))) {
            return this.redirectURL(this.createServiceUrl(request, this._homeRedirectUrl, lang, portal));
        }
        if (this.sourceRepository.findByType(SourceType.portal, null).size() == 0) {
            return this.redirectURL(this.createServiceUrl(request, this._homeRedirectUrl, lang, "srv"));
        }
        return this.redirectURL(this._portalHomeRedirectUrl);
    }

    @RequestMapping(value={"/{portal}", "/{portal}/"})
    public ModelAndView redirectPortalPath(HttpServletRequest request, @PathVariable String portal, @CookieValue(value="geonetwork_Preferred_Language_Cookie", required=false) String langCookie, @RequestHeader(value="Accept", required=false) String accept, @RequestParam(value="hl", required=false) String langParam, @RequestHeader(value="Accept-Language", required=false) String langHeader) throws ResourceNotFoundException {
        String lang = this.lang(langParam, langCookie, langHeader);
        if (this.checkPortalExist(portal, !accept.startsWith(ACCEPT_VALUE))) {
            return this.redirectURL(this.createServiceUrl(request, this._homeRedirectUrl, lang, portal));
        }
        if (this.sourceRepository.findByType(SourceType.subportal, null).size() == 0) {
            return this.redirectURL(this.createServiceUrl(request, this._homeRedirectUrl, lang, "srv"));
        }
        return this.redirectURL(this._portalHomeRedirectUrl);
    }

    private boolean checkPortalExist(String portal, boolean throwException) throws ResourceNotFoundException {
        if (portal == null || "srv".equals(portal)) {
            return true;
        }
        Optional one = this.sourceRepository.findById((Object)portal);
        if (!one.isPresent()) {
            ArrayList<String> portalList = new ArrayList<String>();
            portalList.add("srv");
            this.sourceRepository.findByType(SourceType.subportal, null).forEach(e -> portalList.add(e.getUuid()));
            if (throwException) {
                throw new ResourceNotFoundException(String.format("No portal found with id '%s'. The list of available portals are: %s", portal, ((Object)portalList).toString()));
            }
            return false;
        }
        return true;
    }

    @RequestMapping(value={"/login.jsp"})
    public ModelAndView login(HttpServletRequest request, @RequestParam(value="hl", required=false) String langParam, @RequestParam(value="node", required=false) String node, @CookieValue(value="geonetwork_Preferred_Language_Cookie", required=false) String langCookie, @RequestHeader(value="Accept-Language", required=false) String langHeader) {
        String lang = this.lang(langParam, langCookie, langHeader);
        return this.redirectURL(this.createServiceUrl(request, "catalog.signin", lang, node));
    }

    @RequestMapping(value={"/accessDenied.jsp"})
    public ModelAndView accessDenied(HttpServletRequest request, @RequestParam(value="hl", required=false) String langParam, @RequestParam(value="node", required=false) String node, @CookieValue(value="geonetwork_Preferred_Language_Cookie", required=false) String langCookie, @RequestParam(value="referer", required=false) String referer, @RequestHeader(value="Accept-Language", required=false) String langHeader) {
        String lang = this.lang(langParam, langCookie, langHeader);
        if (referer == null || referer.trim().isEmpty() || referer.contains("accessDenied") || referer.contains("service-not-allowed")) {
            referer = "UNKNOWN";
        }
        return this.redirectURL(this.createServiceUrl(request, "service-not-allowed?referer=" + referer, lang, node));
    }

    private ModelAndView redirectURL(String url) {
        RedirectView rv = new RedirectView(url);
        rv.setStatusCode(HttpStatus.FOUND);
        return new ModelAndView((View)rv);
    }

    private String createServiceUrl(HttpServletRequest request, String service, String lang, String node) {
        node = node == null ? this.currentNode.getId() : node;
        Enumeration parameterNames = request.getParameterNames();
        StringBuilder headers = new StringBuilder();
        while (parameterNames.hasMoreElements()) {
            String paramName = (String)parameterNames.nextElement();
            if (SPECIAL_HEADERS.contains(paramName)) continue;
            for (String value : request.getParameterValues(paramName)) {
                if (headers.length() > 0) {
                    headers.append('&');
                }
                headers.append(paramName);
                if (value.isEmpty()) continue;
                headers.append('=').append(value);
            }
        }
        String queryString = headers.length() == 0 ? "" : (service.contains("?") ? "&" + headers : "?" + headers);
        return request.getContextPath() + "/" + node + "/" + lang + "/" + service + queryString;
    }

    private String lang(String langParam, String langCookie, String langHeader) {
        if (this.defaultLanguage.isForceDefault()) {
            return this.defaultLanguage.getLanguage();
        }
        if (langParam != null) {
            return langParam;
        }
        if (langCookie != null) {
            return langCookie;
        }
        if (langHeader == null) {
            return this.defaultLanguage.getLanguage();
        }
        String userLang = langHeader.split("-|,", 2)[0].toLowerCase();
        userLang = userLang.matches("^en") ? "eng" : (userLang.matches("^fr") ? "fre" : (userLang.matches("^de") ? "ger" : (userLang.matches("^it") ? "ita" : (userLang.matches("^ca") ? "cat" : (userLang.matches("^es") ? "spa" : (userLang.matches("^fi") ? "fin" : (userLang.matches("^pl") ? "pol" : (userLang.matches("^no") ? "nor" : (userLang.matches("^nl") ? "dut" : (userLang.matches("^pt") ? "por" : (userLang.matches("^ar") ? "ara" : (userLang.matches("^zh") ? "chi" : (userLang.matches("^ru") ? "rus" : (userLang.matches("^tr") ? "tur" : this.defaultLanguage.getLanguage()))))))))))))));
        return userLang;
    }

    static {
        HashSet<String> headers = new HashSet<String>();
        headers.add(LANG_PARAMETER);
        headers.add(REFERER_PARAMETER);
        SPECIAL_HEADERS = Collections.unmodifiableSet(headers);
    }
}

