/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.schema;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.fao.geonet.kernel.schema.AttributeEntry;
import org.fao.geonet.kernel.schema.ElementInfo;
import org.fao.geonet.kernel.schema.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

class AttributeGroupEntry {
    public String name;
    public String ref;
    public ArrayList<AttributeEntry> alAttrs = new ArrayList();
    public ArrayList<AttributeGroupEntry> alAttrGrps = new ArrayList();

    public AttributeGroupEntry(Element el, Path file, String targetNS, String targetNSPrefix) {
        this(new ElementInfo(el, file, targetNS, targetNSPrefix));
    }

    public AttributeGroupEntry(ElementInfo ei) {
        this.handleAttribs(ei);
        this.handleChildren(ei);
    }

    private void handleAttribs(ElementInfo ei) {
        List attribs = ei.element.getAttributes();
        for (Attribute at : attribs) {
            String attrName = at.getName();
            if (attrName.equals("name")) {
                this.name = at.getValue();
                if (ei.targetNSPrefix == null) continue;
                this.name = ei.targetNSPrefix + ":" + this.name;
                continue;
            }
            if (attrName.equals("ref")) {
                this.ref = at.getValue();
                continue;
            }
            Logger.log();
        }
    }

    private void handleChildren(ElementInfo ei) {
        List children = ei.element.getChildren();
        for (Element elChild : children) {
            String elName = elChild.getName();
            if (elName.equals("attribute")) {
                AttributeEntry at = new AttributeEntry(elChild, ei.file, ei.targetNS, ei.targetNSPrefix);
                this.alAttrs.add(at);
                continue;
            }
            if (elName.equals("attributeGroup")) {
                AttributeGroupEntry age = new AttributeGroupEntry(elChild, ei.file, ei.targetNS, ei.targetNSPrefix);
                this.alAttrGrps.add(age);
                continue;
            }
            if (elName.equals("annotation")) continue;
            Logger.log();
        }
    }
}

