/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import java.sql.SQLException;
import jeeves.server.context.ServiceContext;
import jeeves.xlink.Processor;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.kernel.SvnManager;
import org.fao.geonet.kernel.XmlSerializer;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class XmlSerializerSvn
extends XmlSerializer {
    @Override
    protected Element internalSelect(String id, boolean isIndexingTask, boolean applyOperationsFilters) throws Exception {
        Element rec = super.internalSelect(id, isIndexingTask, applyOperationsFilters);
        if (rec != null) {
            return (Element)rec.detach();
        }
        return null;
    }

    @Override
    public Element select(ServiceContext context, String id) throws Exception {
        Element rec = this.internalSelect(id, false, false);
        if (this.resolveXLinks()) {
            Processor.detachXLink(rec, context);
        }
        return rec;
    }

    @Override
    public Element selectNoXLinkResolver(String id, boolean isIndexingTask, boolean applyOperationsFilters) throws Exception {
        return this.internalSelect(id, isIndexingTask, applyOperationsFilters);
    }

    @Override
    public AbstractMetadata insert(AbstractMetadata newMetadata, Element dataXml, ServiceContext context) throws SQLException {
        return this.insertDb(newMetadata, dataXml, context);
    }

    @Override
    public void update(String id, Element xml, String changeDate, boolean updateDateStamp, String uuid, ServiceContext context) throws Exception {
        SvnManager svnMan = context.getBean(SvnManager.class);
        this.updateDb(id, xml, changeDate, xml.getQualifiedName(), updateDateStamp, uuid);
        svnMan.setHistory(id, context);
    }

    @Override
    public void delete(String id, ServiceContext context) throws Exception {
        this.deleteDb(id);
        try {
            SvnManager svnMan = context.getBean(SvnManager.class);
            svnMan.deleteDir(id, context);
        }
        catch (NoSuchBeanDefinitionException e) {
            Log.error((String)"geonetwork.datamanager", (Object)"SVN manager not found. No SVN repository available.");
        }
    }
}

